/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.FlowConnectionConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.FlowConnectionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowConnection> {
    private static final SdkField<FlowConnectionConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(FlowConnection.getter(FlowConnection::configuration)).setter(FlowConnection.setter(Builder::configuration)).constructor(FlowConnectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(FlowConnection.getter(FlowConnection::name)).setter(FlowConnection.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(FlowConnection.getter(FlowConnection::source)).setter(FlowConnection.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("target").getter(FlowConnection.getter(FlowConnection::target)).setter(FlowConnection.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FlowConnection.getter(FlowConnection::typeAsString)).setter(FlowConnection.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, NAME_FIELD, SOURCE_FIELD, TARGET_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final FlowConnectionConfiguration configuration;
    private final String name;
    private final String source;
    private final String target;
    private final String type;

    private FlowConnection(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.name = builder.name;
        this.source = builder.source;
        this.target = builder.target;
        this.type = builder.type;
    }

    public final FlowConnectionConfiguration configuration() {
        return this.configuration;
    }

    public final String name() {
        return this.name;
    }

    public final String source() {
        return this.source;
    }

    public final String target() {
        return this.target;
    }

    public final FlowConnectionType type() {
        return FlowConnectionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowConnection)) {
            return false;
        }
        FlowConnection other = (FlowConnection)obj;
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FlowConnection").add("Configuration", (Object)this.configuration()).add("Name", (Object)this.name()).add("Source", (Object)this.source()).add("Target", (Object)this.target()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowConnection, T> g) {
        return obj -> g.apply((FlowConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FlowConnectionConfiguration configuration;
        private String name;
        private String source;
        private String target;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowConnection model) {
            this.configuration(model.configuration);
            this.name(model.name);
            this.source(model.source);
            this.target(model.target);
            this.type(model.type);
        }

        public final FlowConnectionConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(FlowConnectionConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(FlowConnectionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowConnectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public FlowConnection build() {
            return new FlowConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowConnection> {
        public Builder configuration(FlowConnectionConfiguration var1);

        default public Builder configuration(Consumer<FlowConnectionConfiguration.Builder> configuration) {
            return this.configuration((FlowConnectionConfiguration)((FlowConnectionConfiguration.Builder)FlowConnectionConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder name(String var1);

        public Builder source(String var1);

        public Builder target(String var1);

        public Builder type(String var1);

        public Builder type(FlowConnectionType var1);
    }
}

