/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.EnabledMemoryTypesCopier;
import software.amazon.awssdk.services.bedrockagent.model.MemoryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemoryConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemoryConfiguration> {
    private static final SdkField<List<String>> ENABLED_MEMORY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("enabledMemoryTypes").getter(MemoryConfiguration.getter(MemoryConfiguration::enabledMemoryTypesAsStrings)).setter(MemoryConfiguration.setter(Builder::enabledMemoryTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledMemoryTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> STORAGE_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageDays").getter(MemoryConfiguration.getter(MemoryConfiguration::storageDays)).setter(MemoryConfiguration.setter(Builder::storageDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_MEMORY_TYPES_FIELD, STORAGE_DAYS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> enabledMemoryTypes;
    private final Integer storageDays;

    private MemoryConfiguration(BuilderImpl builder) {
        this.enabledMemoryTypes = builder.enabledMemoryTypes;
        this.storageDays = builder.storageDays;
    }

    public final List<MemoryType> enabledMemoryTypes() {
        return EnabledMemoryTypesCopier.copyStringToEnum(this.enabledMemoryTypes);
    }

    public final boolean hasEnabledMemoryTypes() {
        return this.enabledMemoryTypes != null && !(this.enabledMemoryTypes instanceof SdkAutoConstructList);
    }

    public final List<String> enabledMemoryTypesAsStrings() {
        return this.enabledMemoryTypes;
    }

    public final Integer storageDays() {
        return this.storageDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledMemoryTypes() ? this.enabledMemoryTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageDays());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryConfiguration)) {
            return false;
        }
        MemoryConfiguration other = (MemoryConfiguration)obj;
        return this.hasEnabledMemoryTypes() == other.hasEnabledMemoryTypes() && Objects.equals(this.enabledMemoryTypesAsStrings(), other.enabledMemoryTypesAsStrings()) && Objects.equals(this.storageDays(), other.storageDays());
    }

    public final String toString() {
        return ToString.builder((String)"MemoryConfiguration").add("EnabledMemoryTypes", this.hasEnabledMemoryTypes() ? this.enabledMemoryTypesAsStrings() : null).add("StorageDays", (Object)this.storageDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabledMemoryTypes": {
                return Optional.ofNullable(clazz.cast(this.enabledMemoryTypesAsStrings()));
            }
            case "storageDays": {
                return Optional.ofNullable(clazz.cast(this.storageDays()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemoryConfiguration, T> g) {
        return obj -> g.apply((MemoryConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> enabledMemoryTypes = DefaultSdkAutoConstructList.getInstance();
        private Integer storageDays;

        private BuilderImpl() {
        }

        private BuilderImpl(MemoryConfiguration model) {
            this.enabledMemoryTypesWithStrings(model.enabledMemoryTypes);
            this.storageDays(model.storageDays);
        }

        public final Collection<String> getEnabledMemoryTypes() {
            if (this.enabledMemoryTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledMemoryTypes;
        }

        public final void setEnabledMemoryTypes(Collection<String> enabledMemoryTypes) {
            this.enabledMemoryTypes = EnabledMemoryTypesCopier.copy(enabledMemoryTypes);
        }

        @Override
        public final Builder enabledMemoryTypesWithStrings(Collection<String> enabledMemoryTypes) {
            this.enabledMemoryTypes = EnabledMemoryTypesCopier.copy(enabledMemoryTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledMemoryTypesWithStrings(String ... enabledMemoryTypes) {
            this.enabledMemoryTypesWithStrings(Arrays.asList(enabledMemoryTypes));
            return this;
        }

        @Override
        public final Builder enabledMemoryTypes(Collection<MemoryType> enabledMemoryTypes) {
            this.enabledMemoryTypes = EnabledMemoryTypesCopier.copyEnumToString(enabledMemoryTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledMemoryTypes(MemoryType ... enabledMemoryTypes) {
            this.enabledMemoryTypes(Arrays.asList(enabledMemoryTypes));
            return this;
        }

        public final Integer getStorageDays() {
            return this.storageDays;
        }

        public final void setStorageDays(Integer storageDays) {
            this.storageDays = storageDays;
        }

        @Override
        public final Builder storageDays(Integer storageDays) {
            this.storageDays = storageDays;
            return this;
        }

        public MemoryConfiguration build() {
            return new MemoryConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemoryConfiguration> {
        public Builder enabledMemoryTypesWithStrings(Collection<String> var1);

        public Builder enabledMemoryTypesWithStrings(String ... var1);

        public Builder enabledMemoryTypes(Collection<MemoryType> var1);

        public Builder enabledMemoryTypes(MemoryType ... var1);

        public Builder storageDays(Integer var1);
    }
}

