/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseStorageType;
import software.amazon.awssdk.services.bedrockagent.model.MongoDbAtlasConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.OpenSearchServerlessConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.PineconeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.RdsConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.RedisEnterpriseCloudConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageConfiguration> {
    private static final SdkField<MongoDbAtlasConfiguration> MONGO_DB_ATLAS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mongoDbAtlasConfiguration").getter(StorageConfiguration.getter(StorageConfiguration::mongoDbAtlasConfiguration)).setter(StorageConfiguration.setter(Builder::mongoDbAtlasConfiguration)).constructor(MongoDbAtlasConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mongoDbAtlasConfiguration").build()}).build();
    private static final SdkField<OpenSearchServerlessConfiguration> OPENSEARCH_SERVERLESS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("opensearchServerlessConfiguration").getter(StorageConfiguration.getter(StorageConfiguration::opensearchServerlessConfiguration)).setter(StorageConfiguration.setter(Builder::opensearchServerlessConfiguration)).constructor(OpenSearchServerlessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("opensearchServerlessConfiguration").build()}).build();
    private static final SdkField<PineconeConfiguration> PINECONE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pineconeConfiguration").getter(StorageConfiguration.getter(StorageConfiguration::pineconeConfiguration)).setter(StorageConfiguration.setter(Builder::pineconeConfiguration)).constructor(PineconeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pineconeConfiguration").build()}).build();
    private static final SdkField<RdsConfiguration> RDS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rdsConfiguration").getter(StorageConfiguration.getter(StorageConfiguration::rdsConfiguration)).setter(StorageConfiguration.setter(Builder::rdsConfiguration)).constructor(RdsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsConfiguration").build()}).build();
    private static final SdkField<RedisEnterpriseCloudConfiguration> REDIS_ENTERPRISE_CLOUD_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("redisEnterpriseCloudConfiguration").getter(StorageConfiguration.getter(StorageConfiguration::redisEnterpriseCloudConfiguration)).setter(StorageConfiguration.setter(Builder::redisEnterpriseCloudConfiguration)).constructor(RedisEnterpriseCloudConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redisEnterpriseCloudConfiguration").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(StorageConfiguration.getter(StorageConfiguration::typeAsString)).setter(StorageConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONGO_DB_ATLAS_CONFIGURATION_FIELD, OPENSEARCH_SERVERLESS_CONFIGURATION_FIELD, PINECONE_CONFIGURATION_FIELD, RDS_CONFIGURATION_FIELD, REDIS_ENTERPRISE_CLOUD_CONFIGURATION_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final MongoDbAtlasConfiguration mongoDbAtlasConfiguration;
    private final OpenSearchServerlessConfiguration opensearchServerlessConfiguration;
    private final PineconeConfiguration pineconeConfiguration;
    private final RdsConfiguration rdsConfiguration;
    private final RedisEnterpriseCloudConfiguration redisEnterpriseCloudConfiguration;
    private final String type;

    private StorageConfiguration(BuilderImpl builder) {
        this.mongoDbAtlasConfiguration = builder.mongoDbAtlasConfiguration;
        this.opensearchServerlessConfiguration = builder.opensearchServerlessConfiguration;
        this.pineconeConfiguration = builder.pineconeConfiguration;
        this.rdsConfiguration = builder.rdsConfiguration;
        this.redisEnterpriseCloudConfiguration = builder.redisEnterpriseCloudConfiguration;
        this.type = builder.type;
    }

    public final MongoDbAtlasConfiguration mongoDbAtlasConfiguration() {
        return this.mongoDbAtlasConfiguration;
    }

    public final OpenSearchServerlessConfiguration opensearchServerlessConfiguration() {
        return this.opensearchServerlessConfiguration;
    }

    public final PineconeConfiguration pineconeConfiguration() {
        return this.pineconeConfiguration;
    }

    public final RdsConfiguration rdsConfiguration() {
        return this.rdsConfiguration;
    }

    public final RedisEnterpriseCloudConfiguration redisEnterpriseCloudConfiguration() {
        return this.redisEnterpriseCloudConfiguration;
    }

    public final KnowledgeBaseStorageType type() {
        return KnowledgeBaseStorageType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mongoDbAtlasConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.opensearchServerlessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.pineconeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.redisEnterpriseCloudConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageConfiguration)) {
            return false;
        }
        StorageConfiguration other = (StorageConfiguration)obj;
        return Objects.equals(this.mongoDbAtlasConfiguration(), other.mongoDbAtlasConfiguration()) && Objects.equals(this.opensearchServerlessConfiguration(), other.opensearchServerlessConfiguration()) && Objects.equals(this.pineconeConfiguration(), other.pineconeConfiguration()) && Objects.equals(this.rdsConfiguration(), other.rdsConfiguration()) && Objects.equals(this.redisEnterpriseCloudConfiguration(), other.redisEnterpriseCloudConfiguration()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StorageConfiguration").add("MongoDbAtlasConfiguration", (Object)this.mongoDbAtlasConfiguration()).add("OpensearchServerlessConfiguration", (Object)this.opensearchServerlessConfiguration()).add("PineconeConfiguration", (Object)this.pineconeConfiguration()).add("RdsConfiguration", (Object)this.rdsConfiguration()).add("RedisEnterpriseCloudConfiguration", (Object)this.redisEnterpriseCloudConfiguration()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mongoDbAtlasConfiguration": {
                return Optional.ofNullable(clazz.cast(this.mongoDbAtlasConfiguration()));
            }
            case "opensearchServerlessConfiguration": {
                return Optional.ofNullable(clazz.cast(this.opensearchServerlessConfiguration()));
            }
            case "pineconeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.pineconeConfiguration()));
            }
            case "rdsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rdsConfiguration()));
            }
            case "redisEnterpriseCloudConfiguration": {
                return Optional.ofNullable(clazz.cast(this.redisEnterpriseCloudConfiguration()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageConfiguration, T> g) {
        return obj -> g.apply((StorageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MongoDbAtlasConfiguration mongoDbAtlasConfiguration;
        private OpenSearchServerlessConfiguration opensearchServerlessConfiguration;
        private PineconeConfiguration pineconeConfiguration;
        private RdsConfiguration rdsConfiguration;
        private RedisEnterpriseCloudConfiguration redisEnterpriseCloudConfiguration;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageConfiguration model) {
            this.mongoDbAtlasConfiguration(model.mongoDbAtlasConfiguration);
            this.opensearchServerlessConfiguration(model.opensearchServerlessConfiguration);
            this.pineconeConfiguration(model.pineconeConfiguration);
            this.rdsConfiguration(model.rdsConfiguration);
            this.redisEnterpriseCloudConfiguration(model.redisEnterpriseCloudConfiguration);
            this.type(model.type);
        }

        public final MongoDbAtlasConfiguration.Builder getMongoDbAtlasConfiguration() {
            return this.mongoDbAtlasConfiguration != null ? this.mongoDbAtlasConfiguration.toBuilder() : null;
        }

        public final void setMongoDbAtlasConfiguration(MongoDbAtlasConfiguration.BuilderImpl mongoDbAtlasConfiguration) {
            this.mongoDbAtlasConfiguration = mongoDbAtlasConfiguration != null ? mongoDbAtlasConfiguration.build() : null;
        }

        @Override
        public final Builder mongoDbAtlasConfiguration(MongoDbAtlasConfiguration mongoDbAtlasConfiguration) {
            this.mongoDbAtlasConfiguration = mongoDbAtlasConfiguration;
            return this;
        }

        public final OpenSearchServerlessConfiguration.Builder getOpensearchServerlessConfiguration() {
            return this.opensearchServerlessConfiguration != null ? this.opensearchServerlessConfiguration.toBuilder() : null;
        }

        public final void setOpensearchServerlessConfiguration(OpenSearchServerlessConfiguration.BuilderImpl opensearchServerlessConfiguration) {
            this.opensearchServerlessConfiguration = opensearchServerlessConfiguration != null ? opensearchServerlessConfiguration.build() : null;
        }

        @Override
        public final Builder opensearchServerlessConfiguration(OpenSearchServerlessConfiguration opensearchServerlessConfiguration) {
            this.opensearchServerlessConfiguration = opensearchServerlessConfiguration;
            return this;
        }

        public final PineconeConfiguration.Builder getPineconeConfiguration() {
            return this.pineconeConfiguration != null ? this.pineconeConfiguration.toBuilder() : null;
        }

        public final void setPineconeConfiguration(PineconeConfiguration.BuilderImpl pineconeConfiguration) {
            this.pineconeConfiguration = pineconeConfiguration != null ? pineconeConfiguration.build() : null;
        }

        @Override
        public final Builder pineconeConfiguration(PineconeConfiguration pineconeConfiguration) {
            this.pineconeConfiguration = pineconeConfiguration;
            return this;
        }

        public final RdsConfiguration.Builder getRdsConfiguration() {
            return this.rdsConfiguration != null ? this.rdsConfiguration.toBuilder() : null;
        }

        public final void setRdsConfiguration(RdsConfiguration.BuilderImpl rdsConfiguration) {
            this.rdsConfiguration = rdsConfiguration != null ? rdsConfiguration.build() : null;
        }

        @Override
        public final Builder rdsConfiguration(RdsConfiguration rdsConfiguration) {
            this.rdsConfiguration = rdsConfiguration;
            return this;
        }

        public final RedisEnterpriseCloudConfiguration.Builder getRedisEnterpriseCloudConfiguration() {
            return this.redisEnterpriseCloudConfiguration != null ? this.redisEnterpriseCloudConfiguration.toBuilder() : null;
        }

        public final void setRedisEnterpriseCloudConfiguration(RedisEnterpriseCloudConfiguration.BuilderImpl redisEnterpriseCloudConfiguration) {
            this.redisEnterpriseCloudConfiguration = redisEnterpriseCloudConfiguration != null ? redisEnterpriseCloudConfiguration.build() : null;
        }

        @Override
        public final Builder redisEnterpriseCloudConfiguration(RedisEnterpriseCloudConfiguration redisEnterpriseCloudConfiguration) {
            this.redisEnterpriseCloudConfiguration = redisEnterpriseCloudConfiguration;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(KnowledgeBaseStorageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public StorageConfiguration build() {
            return new StorageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageConfiguration> {
        public Builder mongoDbAtlasConfiguration(MongoDbAtlasConfiguration var1);

        default public Builder mongoDbAtlasConfiguration(Consumer<MongoDbAtlasConfiguration.Builder> mongoDbAtlasConfiguration) {
            return this.mongoDbAtlasConfiguration((MongoDbAtlasConfiguration)((MongoDbAtlasConfiguration.Builder)MongoDbAtlasConfiguration.builder().applyMutation(mongoDbAtlasConfiguration)).build());
        }

        public Builder opensearchServerlessConfiguration(OpenSearchServerlessConfiguration var1);

        default public Builder opensearchServerlessConfiguration(Consumer<OpenSearchServerlessConfiguration.Builder> opensearchServerlessConfiguration) {
            return this.opensearchServerlessConfiguration((OpenSearchServerlessConfiguration)((OpenSearchServerlessConfiguration.Builder)OpenSearchServerlessConfiguration.builder().applyMutation(opensearchServerlessConfiguration)).build());
        }

        public Builder pineconeConfiguration(PineconeConfiguration var1);

        default public Builder pineconeConfiguration(Consumer<PineconeConfiguration.Builder> pineconeConfiguration) {
            return this.pineconeConfiguration((PineconeConfiguration)((PineconeConfiguration.Builder)PineconeConfiguration.builder().applyMutation(pineconeConfiguration)).build());
        }

        public Builder rdsConfiguration(RdsConfiguration var1);

        default public Builder rdsConfiguration(Consumer<RdsConfiguration.Builder> rdsConfiguration) {
            return this.rdsConfiguration((RdsConfiguration)((RdsConfiguration.Builder)RdsConfiguration.builder().applyMutation(rdsConfiguration)).build());
        }

        public Builder redisEnterpriseCloudConfiguration(RedisEnterpriseCloudConfiguration var1);

        default public Builder redisEnterpriseCloudConfiguration(Consumer<RedisEnterpriseCloudConfiguration.Builder> redisEnterpriseCloudConfiguration) {
            return this.redisEnterpriseCloudConfiguration((RedisEnterpriseCloudConfiguration)((RedisEnterpriseCloudConfiguration.Builder)RedisEnterpriseCloudConfiguration.builder().applyMutation(redisEnterpriseCloudConfiguration)).build());
        }

        public Builder type(String var1);

        public Builder type(KnowledgeBaseStorageType var1);
    }
}

