/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteKnowledgeBaseResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, DeleteKnowledgeBaseResponse> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(DeleteKnowledgeBaseResponse.getter(DeleteKnowledgeBaseResponse::knowledgeBaseId)).setter(DeleteKnowledgeBaseResponse.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeleteKnowledgeBaseResponse.getter(DeleteKnowledgeBaseResponse::statusAsString)).setter(DeleteKnowledgeBaseResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, STATUS_FIELD));
    private final String knowledgeBaseId;
    private final String status;

    private DeleteKnowledgeBaseResponse(BuilderImpl builder) {
        super(builder);
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.status = builder.status;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final KnowledgeBaseStatus status() {
        return KnowledgeBaseStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteKnowledgeBaseResponse)) {
            return false;
        }
        DeleteKnowledgeBaseResponse other = (DeleteKnowledgeBaseResponse)((Object)obj);
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteKnowledgeBaseResponse").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteKnowledgeBaseResponse, T> g) {
        return obj -> g.apply((DeleteKnowledgeBaseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteKnowledgeBaseResponse model) {
            super(model);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.status(model.status);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KnowledgeBaseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DeleteKnowledgeBaseResponse build() {
            return new DeleteKnowledgeBaseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteKnowledgeBaseResponse> {
        public Builder knowledgeBaseId(String var1);

        public Builder status(String var1);

        public Builder status(KnowledgeBaseStatus var1);
    }
}

