/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseFlowNodeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseFlowNodeConfiguration> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(KnowledgeBaseFlowNodeConfiguration.getter(KnowledgeBaseFlowNodeConfiguration::knowledgeBaseId)).setter(KnowledgeBaseFlowNodeConfiguration.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(KnowledgeBaseFlowNodeConfiguration.getter(KnowledgeBaseFlowNodeConfiguration::modelId)).setter(KnowledgeBaseFlowNodeConfiguration.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, MODEL_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String knowledgeBaseId;
    private final String modelId;

    private KnowledgeBaseFlowNodeConfiguration(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.modelId = builder.modelId;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String modelId() {
        return this.modelId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseFlowNodeConfiguration)) {
            return false;
        }
        KnowledgeBaseFlowNodeConfiguration other = (KnowledgeBaseFlowNodeConfiguration)obj;
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.modelId(), other.modelId());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseFlowNodeConfiguration").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("ModelId", (Object)this.modelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseFlowNodeConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseFlowNodeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private String modelId;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseFlowNodeConfiguration model) {
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.modelId(model.modelId);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public KnowledgeBaseFlowNodeConfiguration build() {
            return new KnowledgeBaseFlowNodeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseFlowNodeConfiguration> {
        public Builder knowledgeBaseId(String var1);

        public Builder modelId(String var1);
    }
}

