/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentAsyncClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.AgentKnowledgeBaseSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesResponse;

public class ListAgentKnowledgeBasesPublisher
implements SdkPublisher<ListAgentKnowledgeBasesResponse> {
    private final BedrockAgentAsyncClient client;
    private final ListAgentKnowledgeBasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAgentKnowledgeBasesPublisher(BedrockAgentAsyncClient client, ListAgentKnowledgeBasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAgentKnowledgeBasesPublisher(BedrockAgentAsyncClient client, ListAgentKnowledgeBasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAgentKnowledgeBasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAgentKnowledgeBasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AgentKnowledgeBaseSummary> agentKnowledgeBaseSummaries() {
        Function<ListAgentKnowledgeBasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentKnowledgeBaseSummaries() != null) {
                return response.agentKnowledgeBaseSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAgentKnowledgeBasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAgentKnowledgeBasesResponseFetcher
    implements AsyncPageFetcher<ListAgentKnowledgeBasesResponse> {
        private ListAgentKnowledgeBasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentKnowledgeBasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAgentKnowledgeBasesResponse> nextPage(ListAgentKnowledgeBasesResponse previousPage) {
            if (previousPage == null) {
                return ListAgentKnowledgeBasesPublisher.this.client.listAgentKnowledgeBases(ListAgentKnowledgeBasesPublisher.this.firstRequest);
            }
            return ListAgentKnowledgeBasesPublisher.this.client.listAgentKnowledgeBases((ListAgentKnowledgeBasesRequest)((Object)ListAgentKnowledgeBasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

