/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentAsyncClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsResponse;

public class ListIngestionJobsPublisher
implements SdkPublisher<ListIngestionJobsResponse> {
    private final BedrockAgentAsyncClient client;
    private final ListIngestionJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIngestionJobsPublisher(BedrockAgentAsyncClient client, ListIngestionJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIngestionJobsPublisher(BedrockAgentAsyncClient client, ListIngestionJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIngestionJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIngestionJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IngestionJobSummary> ingestionJobSummaries() {
        Function<ListIngestionJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ingestionJobSummaries() != null) {
                return response.ingestionJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIngestionJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIngestionJobsResponseFetcher
    implements AsyncPageFetcher<ListIngestionJobsResponse> {
        private ListIngestionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListIngestionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIngestionJobsResponse> nextPage(ListIngestionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListIngestionJobsPublisher.this.client.listIngestionJobs(ListIngestionJobsPublisher.this.firstRequest);
            }
            return ListIngestionJobsPublisher.this.client.listIngestionJobs((ListIngestionJobsRequest)((Object)ListIngestionJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

