/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentAsyncClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.AgentVersionSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsResponse;

public class ListAgentVersionsPublisher
implements SdkPublisher<ListAgentVersionsResponse> {
    private final BedrockAgentAsyncClient client;
    private final ListAgentVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAgentVersionsPublisher(BedrockAgentAsyncClient client, ListAgentVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAgentVersionsPublisher(BedrockAgentAsyncClient client, ListAgentVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAgentVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAgentVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AgentVersionSummary> agentVersionSummaries() {
        Function<ListAgentVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentVersionSummaries() != null) {
                return response.agentVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAgentVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAgentVersionsResponseFetcher
    implements AsyncPageFetcher<ListAgentVersionsResponse> {
        private ListAgentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAgentVersionsResponse> nextPage(ListAgentVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentVersionsPublisher.this.client.listAgentVersions(ListAgentVersionsPublisher.this.firstRequest);
            }
            return ListAgentVersionsPublisher.this.client.listAgentVersions((ListAgentVersionsRequest)((Object)ListAgentVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

