/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasHistoryEvent;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasHistoryEventsCopier;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationCopier;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationListItem;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentAlias
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentAlias> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(AgentAlias.getter(AgentAlias::agentId)).setter(AgentAlias.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasId").getter(AgentAlias.getter(AgentAlias::agentAliasId)).setter(AgentAlias.setter(Builder::agentAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasId").build()}).build();
    private static final SdkField<String> AGENT_ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasName").getter(AgentAlias.getter(AgentAlias::agentAliasName)).setter(AgentAlias.setter(Builder::agentAliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasName").build()}).build();
    private static final SdkField<String> AGENT_ALIAS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasArn").getter(AgentAlias.getter(AgentAlias::agentAliasArn)).setter(AgentAlias.setter(Builder::agentAliasArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(AgentAlias.getter(AgentAlias::clientToken)).setter(AgentAlias.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AgentAlias.getter(AgentAlias::description)).setter(AgentAlias.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<AgentAliasRoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("routingConfiguration").getter(AgentAlias.getter(AgentAlias::routingConfiguration)).setter(AgentAlias.setter(Builder::routingConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentAliasRoutingConfigurationListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AgentAlias.getter(AgentAlias::createdAt)).setter(AgentAlias.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AgentAlias.getter(AgentAlias::updatedAt)).setter(AgentAlias.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<AgentAliasHistoryEvent>> AGENT_ALIAS_HISTORY_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("agentAliasHistoryEvents").getter(AgentAlias.getter(AgentAlias::agentAliasHistoryEvents)).setter(AgentAlias.setter(Builder::agentAliasHistoryEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasHistoryEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentAliasHistoryEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AGENT_ALIAS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasStatus").getter(AgentAlias.getter(AgentAlias::agentAliasStatusAsString)).setter(AgentAlias.setter(Builder::agentAliasStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, AGENT_ALIAS_ID_FIELD, AGENT_ALIAS_NAME_FIELD, AGENT_ALIAS_ARN_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIGURATION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, AGENT_ALIAS_HISTORY_EVENTS_FIELD, AGENT_ALIAS_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String agentId;
    private final String agentAliasId;
    private final String agentAliasName;
    private final String agentAliasArn;
    private final String clientToken;
    private final String description;
    private final List<AgentAliasRoutingConfigurationListItem> routingConfiguration;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final List<AgentAliasHistoryEvent> agentAliasHistoryEvents;
    private final String agentAliasStatus;

    private AgentAlias(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.agentAliasId = builder.agentAliasId;
        this.agentAliasName = builder.agentAliasName;
        this.agentAliasArn = builder.agentAliasArn;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.routingConfiguration = builder.routingConfiguration;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.agentAliasHistoryEvents = builder.agentAliasHistoryEvents;
        this.agentAliasStatus = builder.agentAliasStatus;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String agentAliasId() {
        return this.agentAliasId;
    }

    public final String agentAliasName() {
        return this.agentAliasName;
    }

    public final String agentAliasArn() {
        return this.agentAliasArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRoutingConfiguration() {
        return this.routingConfiguration != null && !(this.routingConfiguration instanceof SdkAutoConstructList);
    }

    public final List<AgentAliasRoutingConfigurationListItem> routingConfiguration() {
        return this.routingConfiguration;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasAgentAliasHistoryEvents() {
        return this.agentAliasHistoryEvents != null && !(this.agentAliasHistoryEvents instanceof SdkAutoConstructList);
    }

    public final List<AgentAliasHistoryEvent> agentAliasHistoryEvents() {
        return this.agentAliasHistoryEvents;
    }

    public final AgentAliasStatus agentAliasStatus() {
        return AgentAliasStatus.fromValue(this.agentAliasStatus);
    }

    public final String agentAliasStatusAsString() {
        return this.agentAliasStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingConfiguration() ? this.routingConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentAliasHistoryEvents() ? this.agentAliasHistoryEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentAlias)) {
            return false;
        }
        AgentAlias other = (AgentAlias)obj;
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.agentAliasId(), other.agentAliasId()) && Objects.equals(this.agentAliasName(), other.agentAliasName()) && Objects.equals(this.agentAliasArn(), other.agentAliasArn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && this.hasRoutingConfiguration() == other.hasRoutingConfiguration() && Objects.equals(this.routingConfiguration(), other.routingConfiguration()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasAgentAliasHistoryEvents() == other.hasAgentAliasHistoryEvents() && Objects.equals(this.agentAliasHistoryEvents(), other.agentAliasHistoryEvents()) && Objects.equals(this.agentAliasStatusAsString(), other.agentAliasStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AgentAlias").add("AgentId", (Object)this.agentId()).add("AgentAliasId", (Object)this.agentAliasId()).add("AgentAliasName", (Object)this.agentAliasName()).add("AgentAliasArn", (Object)this.agentAliasArn()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("RoutingConfiguration", this.hasRoutingConfiguration() ? this.routingConfiguration() : null).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("AgentAliasHistoryEvents", this.hasAgentAliasHistoryEvents() ? this.agentAliasHistoryEvents() : null).add("AgentAliasStatus", (Object)this.agentAliasStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "agentAliasId": {
                return Optional.ofNullable(clazz.cast(this.agentAliasId()));
            }
            case "agentAliasName": {
                return Optional.ofNullable(clazz.cast(this.agentAliasName()));
            }
            case "agentAliasArn": {
                return Optional.ofNullable(clazz.cast(this.agentAliasArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "routingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.routingConfiguration()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "agentAliasHistoryEvents": {
                return Optional.ofNullable(clazz.cast(this.agentAliasHistoryEvents()));
            }
            case "agentAliasStatus": {
                return Optional.ofNullable(clazz.cast(this.agentAliasStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentAlias, T> g) {
        return obj -> g.apply((AgentAlias)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentId;
        private String agentAliasId;
        private String agentAliasName;
        private String agentAliasArn;
        private String clientToken;
        private String description;
        private List<AgentAliasRoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant updatedAt;
        private List<AgentAliasHistoryEvent> agentAliasHistoryEvents = DefaultSdkAutoConstructList.getInstance();
        private String agentAliasStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentAlias model) {
            this.agentId(model.agentId);
            this.agentAliasId(model.agentAliasId);
            this.agentAliasName(model.agentAliasName);
            this.agentAliasArn(model.agentAliasArn);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.routingConfiguration(model.routingConfiguration);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.agentAliasHistoryEvents(model.agentAliasHistoryEvents);
            this.agentAliasStatus(model.agentAliasStatus);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentAliasId() {
            return this.agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getAgentAliasName() {
            return this.agentAliasName;
        }

        public final void setAgentAliasName(String agentAliasName) {
            this.agentAliasName = agentAliasName;
        }

        @Override
        public final Builder agentAliasName(String agentAliasName) {
            this.agentAliasName = agentAliasName;
            return this;
        }

        public final String getAgentAliasArn() {
            return this.agentAliasArn;
        }

        public final void setAgentAliasArn(String agentAliasArn) {
            this.agentAliasArn = agentAliasArn;
        }

        @Override
        public final Builder agentAliasArn(String agentAliasArn) {
            this.agentAliasArn = agentAliasArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AgentAliasRoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<AgentAliasRoutingConfigurationListItem.Builder> result = AgentAliasRoutingConfigurationCopier.copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(Collection<AgentAliasRoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = AgentAliasRoutingConfigurationCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<AgentAliasRoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = AgentAliasRoutingConfigurationCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(AgentAliasRoutingConfigurationListItem ... routingConfiguration) {
            this.routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(Consumer<AgentAliasRoutingConfigurationListItem.Builder> ... routingConfiguration) {
            this.routingConfiguration(Stream.of(routingConfiguration).map(c -> (AgentAliasRoutingConfigurationListItem)((AgentAliasRoutingConfigurationListItem.Builder)AgentAliasRoutingConfigurationListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<AgentAliasHistoryEvent.Builder> getAgentAliasHistoryEvents() {
            List<AgentAliasHistoryEvent.Builder> result = AgentAliasHistoryEventsCopier.copyToBuilder(this.agentAliasHistoryEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentAliasHistoryEvents(Collection<AgentAliasHistoryEvent.BuilderImpl> agentAliasHistoryEvents) {
            this.agentAliasHistoryEvents = AgentAliasHistoryEventsCopier.copyFromBuilder(agentAliasHistoryEvents);
        }

        @Override
        public final Builder agentAliasHistoryEvents(Collection<AgentAliasHistoryEvent> agentAliasHistoryEvents) {
            this.agentAliasHistoryEvents = AgentAliasHistoryEventsCopier.copy(agentAliasHistoryEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentAliasHistoryEvents(AgentAliasHistoryEvent ... agentAliasHistoryEvents) {
            this.agentAliasHistoryEvents(Arrays.asList(agentAliasHistoryEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentAliasHistoryEvents(Consumer<AgentAliasHistoryEvent.Builder> ... agentAliasHistoryEvents) {
            this.agentAliasHistoryEvents(Stream.of(agentAliasHistoryEvents).map(c -> (AgentAliasHistoryEvent)((AgentAliasHistoryEvent.Builder)AgentAliasHistoryEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAgentAliasStatus() {
            return this.agentAliasStatus;
        }

        public final void setAgentAliasStatus(String agentAliasStatus) {
            this.agentAliasStatus = agentAliasStatus;
        }

        @Override
        public final Builder agentAliasStatus(String agentAliasStatus) {
            this.agentAliasStatus = agentAliasStatus;
            return this;
        }

        @Override
        public final Builder agentAliasStatus(AgentAliasStatus agentAliasStatus) {
            this.agentAliasStatus(agentAliasStatus == null ? null : agentAliasStatus.toString());
            return this;
        }

        public AgentAlias build() {
            return new AgentAlias(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentAlias> {
        public Builder agentId(String var1);

        public Builder agentAliasId(String var1);

        public Builder agentAliasName(String var1);

        public Builder agentAliasArn(String var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder routingConfiguration(Collection<AgentAliasRoutingConfigurationListItem> var1);

        public Builder routingConfiguration(AgentAliasRoutingConfigurationListItem ... var1);

        public Builder routingConfiguration(Consumer<AgentAliasRoutingConfigurationListItem.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder agentAliasHistoryEvents(Collection<AgentAliasHistoryEvent> var1);

        public Builder agentAliasHistoryEvents(AgentAliasHistoryEvent ... var1);

        public Builder agentAliasHistoryEvents(Consumer<AgentAliasHistoryEvent.Builder> ... var1);

        public Builder agentAliasStatus(String var1);

        public Builder agentAliasStatus(AgentAliasStatus var1);
    }
}

