/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.DataSourceSummariesCopier;
import software.amazon.awssdk.services.bedrockagent.model.DataSourceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataSourcesResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, ListDataSourcesResponse> {
    private static final SdkField<List<DataSourceSummary>> DATA_SOURCE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataSourceSummaries").getter(ListDataSourcesResponse.getter(ListDataSourcesResponse::dataSourceSummaries)).setter(ListDataSourcesResponse.setter(Builder::dataSourceSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataSourcesResponse.getter(ListDataSourcesResponse::nextToken)).setter(ListDataSourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<DataSourceSummary> dataSourceSummaries;
    private final String nextToken;

    private ListDataSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.dataSourceSummaries = builder.dataSourceSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDataSourceSummaries() {
        return this.dataSourceSummaries != null && !(this.dataSourceSummaries instanceof SdkAutoConstructList);
    }

    public final List<DataSourceSummary> dataSourceSummaries() {
        return this.dataSourceSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSourceSummaries() ? this.dataSourceSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourcesResponse)) {
            return false;
        }
        ListDataSourcesResponse other = (ListDataSourcesResponse)((Object)obj);
        return this.hasDataSourceSummaries() == other.hasDataSourceSummaries() && Objects.equals(this.dataSourceSummaries(), other.dataSourceSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataSourcesResponse").add("DataSourceSummaries", this.hasDataSourceSummaries() ? this.dataSourceSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSourceSummaries": {
                return Optional.ofNullable(clazz.cast(this.dataSourceSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSourcesResponse, T> g) {
        return obj -> g.apply((ListDataSourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private List<DataSourceSummary> dataSourceSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSourcesResponse model) {
            super(model);
            this.dataSourceSummaries(model.dataSourceSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<DataSourceSummary.Builder> getDataSourceSummaries() {
            List<DataSourceSummary.Builder> result = DataSourceSummariesCopier.copyToBuilder(this.dataSourceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSourceSummaries(Collection<DataSourceSummary.BuilderImpl> dataSourceSummaries) {
            this.dataSourceSummaries = DataSourceSummariesCopier.copyFromBuilder(dataSourceSummaries);
        }

        @Override
        public final Builder dataSourceSummaries(Collection<DataSourceSummary> dataSourceSummaries) {
            this.dataSourceSummaries = DataSourceSummariesCopier.copy(dataSourceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSourceSummaries(DataSourceSummary ... dataSourceSummaries) {
            this.dataSourceSummaries(Arrays.asList(dataSourceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSourceSummaries(Consumer<DataSourceSummary.Builder> ... dataSourceSummaries) {
            this.dataSourceSummaries(Stream.of(dataSourceSummaries).map(c -> (DataSourceSummary)((DataSourceSummary.Builder)DataSourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataSourcesResponse build() {
            return new ListDataSourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataSourcesResponse> {
        public Builder dataSourceSummaries(Collection<DataSourceSummary> var1);

        public Builder dataSourceSummaries(DataSourceSummary ... var1);

        public Builder dataSourceSummaries(Consumer<DataSourceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

