/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.PromptRouterStatus;
import software.amazon.awssdk.services.bedrock.model.PromptRouterTargetModel;
import software.amazon.awssdk.services.bedrock.model.PromptRouterTargetModelsCopier;
import software.amazon.awssdk.services.bedrock.model.PromptRouterType;
import software.amazon.awssdk.services.bedrock.model.RoutingCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PromptRouterSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PromptRouterSummary> {
    private static final SdkField<String> PROMPT_ROUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptRouterName").getter(PromptRouterSummary.getter(PromptRouterSummary::promptRouterName)).setter(PromptRouterSummary.setter(Builder::promptRouterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptRouterName").build()}).build();
    private static final SdkField<RoutingCriteria> ROUTING_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("routingCriteria").getter(PromptRouterSummary.getter(PromptRouterSummary::routingCriteria)).setter(PromptRouterSummary.setter(Builder::routingCriteria)).constructor(RoutingCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingCriteria").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(PromptRouterSummary.getter(PromptRouterSummary::description)).setter(PromptRouterSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(PromptRouterSummary.getter(PromptRouterSummary::createdAt)).setter(PromptRouterSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(PromptRouterSummary.getter(PromptRouterSummary::updatedAt)).setter(PromptRouterSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PROMPT_ROUTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptRouterArn").getter(PromptRouterSummary.getter(PromptRouterSummary::promptRouterArn)).setter(PromptRouterSummary.setter(Builder::promptRouterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptRouterArn").build()}).build();
    private static final SdkField<List<PromptRouterTargetModel>> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("models").getter(PromptRouterSummary.getter(PromptRouterSummary::models)).setter(PromptRouterSummary.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptRouterTargetModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PromptRouterTargetModel> FALLBACK_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fallbackModel").getter(PromptRouterSummary.getter(PromptRouterSummary::fallbackModel)).setter(PromptRouterSummary.setter(Builder::fallbackModel)).constructor(PromptRouterTargetModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackModel").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PromptRouterSummary.getter(PromptRouterSummary::statusAsString)).setter(PromptRouterSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(PromptRouterSummary.getter(PromptRouterSummary::typeAsString)).setter(PromptRouterSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_ROUTER_NAME_FIELD, ROUTING_CRITERIA_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, PROMPT_ROUTER_ARN_FIELD, MODELS_FIELD, FALLBACK_MODEL_FIELD, STATUS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PromptRouterSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String promptRouterName;
    private final RoutingCriteria routingCriteria;
    private final String description;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String promptRouterArn;
    private final List<PromptRouterTargetModel> models;
    private final PromptRouterTargetModel fallbackModel;
    private final String status;
    private final String type;

    private PromptRouterSummary(BuilderImpl builder) {
        this.promptRouterName = builder.promptRouterName;
        this.routingCriteria = builder.routingCriteria;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.promptRouterArn = builder.promptRouterArn;
        this.models = builder.models;
        this.fallbackModel = builder.fallbackModel;
        this.status = builder.status;
        this.type = builder.type;
    }

    public final String promptRouterName() {
        return this.promptRouterName;
    }

    public final RoutingCriteria routingCriteria() {
        return this.routingCriteria;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String promptRouterArn() {
        return this.promptRouterArn;
    }

    public final boolean hasModels() {
        return this.models != null && !(this.models instanceof SdkAutoConstructList);
    }

    public final List<PromptRouterTargetModel> models() {
        return this.models;
    }

    public final PromptRouterTargetModel fallbackModel() {
        return this.fallbackModel;
    }

    public final PromptRouterStatus status() {
        return PromptRouterStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final PromptRouterType type() {
        return PromptRouterType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.promptRouterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptRouterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModels() ? this.models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fallbackModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptRouterSummary)) {
            return false;
        }
        PromptRouterSummary other = (PromptRouterSummary)obj;
        return Objects.equals(this.promptRouterName(), other.promptRouterName()) && Objects.equals(this.routingCriteria(), other.routingCriteria()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.promptRouterArn(), other.promptRouterArn()) && this.hasModels() == other.hasModels() && Objects.equals(this.models(), other.models()) && Objects.equals(this.fallbackModel(), other.fallbackModel()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PromptRouterSummary").add("PromptRouterName", (Object)this.promptRouterName()).add("RoutingCriteria", (Object)this.routingCriteria()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("PromptRouterArn", (Object)this.promptRouterArn()).add("Models", this.hasModels() ? this.models() : null).add("FallbackModel", (Object)this.fallbackModel()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "promptRouterName": {
                return Optional.ofNullable(clazz.cast(this.promptRouterName()));
            }
            case "routingCriteria": {
                return Optional.ofNullable(clazz.cast(this.routingCriteria()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "promptRouterArn": {
                return Optional.ofNullable(clazz.cast(this.promptRouterArn()));
            }
            case "models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
            case "fallbackModel": {
                return Optional.ofNullable(clazz.cast(this.fallbackModel()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("promptRouterName", PROMPT_ROUTER_NAME_FIELD);
        map.put("routingCriteria", ROUTING_CRITERIA_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("promptRouterArn", PROMPT_ROUTER_ARN_FIELD);
        map.put("models", MODELS_FIELD);
        map.put("fallbackModel", FALLBACK_MODEL_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PromptRouterSummary, T> g) {
        return obj -> g.apply((PromptRouterSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String promptRouterName;
        private RoutingCriteria routingCriteria;
        private String description;
        private Instant createdAt;
        private Instant updatedAt;
        private String promptRouterArn;
        private List<PromptRouterTargetModel> models = DefaultSdkAutoConstructList.getInstance();
        private PromptRouterTargetModel fallbackModel;
        private String status;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptRouterSummary model) {
            this.promptRouterName(model.promptRouterName);
            this.routingCriteria(model.routingCriteria);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.promptRouterArn(model.promptRouterArn);
            this.models(model.models);
            this.fallbackModel(model.fallbackModel);
            this.status(model.status);
            this.type(model.type);
        }

        public final String getPromptRouterName() {
            return this.promptRouterName;
        }

        public final void setPromptRouterName(String promptRouterName) {
            this.promptRouterName = promptRouterName;
        }

        @Override
        public final Builder promptRouterName(String promptRouterName) {
            this.promptRouterName = promptRouterName;
            return this;
        }

        public final RoutingCriteria.Builder getRoutingCriteria() {
            return this.routingCriteria != null ? this.routingCriteria.toBuilder() : null;
        }

        public final void setRoutingCriteria(RoutingCriteria.BuilderImpl routingCriteria) {
            this.routingCriteria = routingCriteria != null ? routingCriteria.build() : null;
        }

        @Override
        public final Builder routingCriteria(RoutingCriteria routingCriteria) {
            this.routingCriteria = routingCriteria;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getPromptRouterArn() {
            return this.promptRouterArn;
        }

        public final void setPromptRouterArn(String promptRouterArn) {
            this.promptRouterArn = promptRouterArn;
        }

        @Override
        public final Builder promptRouterArn(String promptRouterArn) {
            this.promptRouterArn = promptRouterArn;
            return this;
        }

        public final List<PromptRouterTargetModel.Builder> getModels() {
            List<PromptRouterTargetModel.Builder> result = PromptRouterTargetModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<PromptRouterTargetModel.BuilderImpl> models) {
            this.models = PromptRouterTargetModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Collection<PromptRouterTargetModel> models) {
            this.models = PromptRouterTargetModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(PromptRouterTargetModel ... models) {
            this.models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<PromptRouterTargetModel.Builder> ... models) {
            this.models(Stream.of(models).map(c -> (PromptRouterTargetModel)((PromptRouterTargetModel.Builder)PromptRouterTargetModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final PromptRouterTargetModel.Builder getFallbackModel() {
            return this.fallbackModel != null ? this.fallbackModel.toBuilder() : null;
        }

        public final void setFallbackModel(PromptRouterTargetModel.BuilderImpl fallbackModel) {
            this.fallbackModel = fallbackModel != null ? fallbackModel.build() : null;
        }

        @Override
        public final Builder fallbackModel(PromptRouterTargetModel fallbackModel) {
            this.fallbackModel = fallbackModel;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PromptRouterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PromptRouterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public PromptRouterSummary build() {
            return new PromptRouterSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PromptRouterSummary> {
        public Builder promptRouterName(String var1);

        public Builder routingCriteria(RoutingCriteria var1);

        default public Builder routingCriteria(Consumer<RoutingCriteria.Builder> routingCriteria) {
            return this.routingCriteria((RoutingCriteria)((RoutingCriteria.Builder)RoutingCriteria.builder().applyMutation(routingCriteria)).build());
        }

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder promptRouterArn(String var1);

        public Builder models(Collection<PromptRouterTargetModel> var1);

        public Builder models(PromptRouterTargetModel ... var1);

        public Builder models(Consumer<PromptRouterTargetModel.Builder> ... var1);

        public Builder fallbackModel(PromptRouterTargetModel var1);

        default public Builder fallbackModel(Consumer<PromptRouterTargetModel.Builder> fallbackModel) {
            return this.fallbackModel((PromptRouterTargetModel)((PromptRouterTargetModel.Builder)PromptRouterTargetModel.builder().applyMutation(fallbackModel)).build());
        }

        public Builder status(String var1);

        public Builder status(PromptRouterStatus var1);

        public Builder type(String var1);

        public Builder type(PromptRouterType var1);
    }
}

