/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.InferenceType;
import software.amazon.awssdk.services.bedrock.model.ModelCustomization;
import software.amazon.awssdk.services.bedrock.model.ModelModality;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFoundationModelsRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, ListFoundationModelsRequest> {
    private static final SdkField<String> BY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("byProvider").getter(ListFoundationModelsRequest.getter(ListFoundationModelsRequest::byProvider)).setter(ListFoundationModelsRequest.setter(Builder::byProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("byProvider").build()}).build();
    private static final SdkField<String> BY_CUSTOMIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("byCustomizationType").getter(ListFoundationModelsRequest.getter(ListFoundationModelsRequest::byCustomizationTypeAsString)).setter(ListFoundationModelsRequest.setter(Builder::byCustomizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("byCustomizationType").build()}).build();
    private static final SdkField<String> BY_OUTPUT_MODALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("byOutputModality").getter(ListFoundationModelsRequest.getter(ListFoundationModelsRequest::byOutputModalityAsString)).setter(ListFoundationModelsRequest.setter(Builder::byOutputModality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("byOutputModality").build()}).build();
    private static final SdkField<String> BY_INFERENCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("byInferenceType").getter(ListFoundationModelsRequest.getter(ListFoundationModelsRequest::byInferenceTypeAsString)).setter(ListFoundationModelsRequest.setter(Builder::byInferenceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("byInferenceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BY_PROVIDER_FIELD, BY_CUSTOMIZATION_TYPE_FIELD, BY_OUTPUT_MODALITY_FIELD, BY_INFERENCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFoundationModelsRequest.memberNameToFieldInitializer();
    private final String byProvider;
    private final String byCustomizationType;
    private final String byOutputModality;
    private final String byInferenceType;

    private ListFoundationModelsRequest(BuilderImpl builder) {
        super(builder);
        this.byProvider = builder.byProvider;
        this.byCustomizationType = builder.byCustomizationType;
        this.byOutputModality = builder.byOutputModality;
        this.byInferenceType = builder.byInferenceType;
    }

    public final String byProvider() {
        return this.byProvider;
    }

    public final ModelCustomization byCustomizationType() {
        return ModelCustomization.fromValue(this.byCustomizationType);
    }

    public final String byCustomizationTypeAsString() {
        return this.byCustomizationType;
    }

    public final ModelModality byOutputModality() {
        return ModelModality.fromValue(this.byOutputModality);
    }

    public final String byOutputModalityAsString() {
        return this.byOutputModality;
    }

    public final InferenceType byInferenceType() {
        return InferenceType.fromValue(this.byInferenceType);
    }

    public final String byInferenceTypeAsString() {
        return this.byInferenceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.byProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCustomizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.byOutputModalityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.byInferenceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFoundationModelsRequest)) {
            return false;
        }
        ListFoundationModelsRequest other = (ListFoundationModelsRequest)((Object)obj);
        return Objects.equals(this.byProvider(), other.byProvider()) && Objects.equals(this.byCustomizationTypeAsString(), other.byCustomizationTypeAsString()) && Objects.equals(this.byOutputModalityAsString(), other.byOutputModalityAsString()) && Objects.equals(this.byInferenceTypeAsString(), other.byInferenceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListFoundationModelsRequest").add("ByProvider", (Object)this.byProvider()).add("ByCustomizationType", (Object)this.byCustomizationTypeAsString()).add("ByOutputModality", (Object)this.byOutputModalityAsString()).add("ByInferenceType", (Object)this.byInferenceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "byProvider": {
                return Optional.ofNullable(clazz.cast(this.byProvider()));
            }
            case "byCustomizationType": {
                return Optional.ofNullable(clazz.cast(this.byCustomizationTypeAsString()));
            }
            case "byOutputModality": {
                return Optional.ofNullable(clazz.cast(this.byOutputModalityAsString()));
            }
            case "byInferenceType": {
                return Optional.ofNullable(clazz.cast(this.byInferenceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("byProvider", BY_PROVIDER_FIELD);
        map.put("byCustomizationType", BY_CUSTOMIZATION_TYPE_FIELD);
        map.put("byOutputModality", BY_OUTPUT_MODALITY_FIELD);
        map.put("byInferenceType", BY_INFERENCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFoundationModelsRequest, T> g) {
        return obj -> g.apply((ListFoundationModelsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String byProvider;
        private String byCustomizationType;
        private String byOutputModality;
        private String byInferenceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFoundationModelsRequest model) {
            super(model);
            this.byProvider(model.byProvider);
            this.byCustomizationType(model.byCustomizationType);
            this.byOutputModality(model.byOutputModality);
            this.byInferenceType(model.byInferenceType);
        }

        public final String getByProvider() {
            return this.byProvider;
        }

        public final void setByProvider(String byProvider) {
            this.byProvider = byProvider;
        }

        @Override
        public final Builder byProvider(String byProvider) {
            this.byProvider = byProvider;
            return this;
        }

        public final String getByCustomizationType() {
            return this.byCustomizationType;
        }

        public final void setByCustomizationType(String byCustomizationType) {
            this.byCustomizationType = byCustomizationType;
        }

        @Override
        public final Builder byCustomizationType(String byCustomizationType) {
            this.byCustomizationType = byCustomizationType;
            return this;
        }

        @Override
        public final Builder byCustomizationType(ModelCustomization byCustomizationType) {
            this.byCustomizationType(byCustomizationType == null ? null : byCustomizationType.toString());
            return this;
        }

        public final String getByOutputModality() {
            return this.byOutputModality;
        }

        public final void setByOutputModality(String byOutputModality) {
            this.byOutputModality = byOutputModality;
        }

        @Override
        public final Builder byOutputModality(String byOutputModality) {
            this.byOutputModality = byOutputModality;
            return this;
        }

        @Override
        public final Builder byOutputModality(ModelModality byOutputModality) {
            this.byOutputModality(byOutputModality == null ? null : byOutputModality.toString());
            return this;
        }

        public final String getByInferenceType() {
            return this.byInferenceType;
        }

        public final void setByInferenceType(String byInferenceType) {
            this.byInferenceType = byInferenceType;
        }

        @Override
        public final Builder byInferenceType(String byInferenceType) {
            this.byInferenceType = byInferenceType;
            return this;
        }

        @Override
        public final Builder byInferenceType(InferenceType byInferenceType) {
            this.byInferenceType(byInferenceType == null ? null : byInferenceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFoundationModelsRequest build() {
            return new ListFoundationModelsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFoundationModelsRequest> {
        public Builder byProvider(String var1);

        public Builder byCustomizationType(String var1);

        public Builder byCustomizationType(ModelCustomization var1);

        public Builder byOutputModality(String var1);

        public Builder byOutputModality(ModelModality var1);

        public Builder byInferenceType(String var1);

        public Builder byInferenceType(InferenceType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

