/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGuardrailResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, UpdateGuardrailResponse> {
    private static final SdkField<String> GUARDRAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailId").getter(UpdateGuardrailResponse.getter(UpdateGuardrailResponse::guardrailId)).setter(UpdateGuardrailResponse.setter(Builder::guardrailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailId").build()}).build();
    private static final SdkField<String> GUARDRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailArn").getter(UpdateGuardrailResponse.getter(UpdateGuardrailResponse::guardrailArn)).setter(UpdateGuardrailResponse.setter(Builder::guardrailArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailArn").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(UpdateGuardrailResponse.getter(UpdateGuardrailResponse::version)).setter(UpdateGuardrailResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(UpdateGuardrailResponse.getter(UpdateGuardrailResponse::updatedAt)).setter(UpdateGuardrailResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_ID_FIELD, GUARDRAIL_ARN_FIELD, VERSION_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateGuardrailResponse.memberNameToFieldInitializer();
    private final String guardrailId;
    private final String guardrailArn;
    private final String version;
    private final Instant updatedAt;

    private UpdateGuardrailResponse(BuilderImpl builder) {
        super(builder);
        this.guardrailId = builder.guardrailId;
        this.guardrailArn = builder.guardrailArn;
        this.version = builder.version;
        this.updatedAt = builder.updatedAt;
    }

    public final String guardrailId() {
        return this.guardrailId;
    }

    public final String guardrailArn() {
        return this.guardrailArn;
    }

    public final String version() {
        return this.version;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGuardrailResponse)) {
            return false;
        }
        UpdateGuardrailResponse other = (UpdateGuardrailResponse)((Object)obj);
        return Objects.equals(this.guardrailId(), other.guardrailId()) && Objects.equals(this.guardrailArn(), other.guardrailArn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGuardrailResponse").add("GuardrailId", (Object)this.guardrailId()).add("GuardrailArn", (Object)this.guardrailArn()).add("Version", (Object)this.version()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrailId": {
                return Optional.ofNullable(clazz.cast(this.guardrailId()));
            }
            case "guardrailArn": {
                return Optional.ofNullable(clazz.cast(this.guardrailArn()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("guardrailId", GUARDRAIL_ID_FIELD);
        map.put("guardrailArn", GUARDRAIL_ARN_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGuardrailResponse, T> g) {
        return obj -> g.apply((UpdateGuardrailResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String guardrailId;
        private String guardrailArn;
        private String version;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGuardrailResponse model) {
            super(model);
            this.guardrailId(model.guardrailId);
            this.guardrailArn(model.guardrailArn);
            this.version(model.version);
            this.updatedAt(model.updatedAt);
        }

        public final String getGuardrailId() {
            return this.guardrailId;
        }

        public final void setGuardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
        }

        @Override
        public final Builder guardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
            return this;
        }

        public final String getGuardrailArn() {
            return this.guardrailArn;
        }

        public final void setGuardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
        }

        @Override
        public final Builder guardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public UpdateGuardrailResponse build() {
            return new UpdateGuardrailResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGuardrailResponse> {
        public Builder guardrailId(String var1);

        public Builder guardrailArn(String var1);

        public Builder version(String var1);

        public Builder updatedAt(Instant var1);
    }
}

