/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.EvaluationBedrockModelIdentifiersCopier;
import software.amazon.awssdk.services.bedrock.model.EvaluationPrecomputedInferenceSourceIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationModelConfigSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationModelConfigSummary> {
    private static final SdkField<List<String>> BEDROCK_MODEL_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bedrockModelIdentifiers").getter(EvaluationModelConfigSummary.getter(EvaluationModelConfigSummary::bedrockModelIdentifiers)).setter(EvaluationModelConfigSummary.setter(Builder::bedrockModelIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockModelIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PRECOMPUTED_INFERENCE_SOURCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("precomputedInferenceSourceIdentifiers").getter(EvaluationModelConfigSummary.getter(EvaluationModelConfigSummary::precomputedInferenceSourceIdentifiers)).setter(EvaluationModelConfigSummary.setter(Builder::precomputedInferenceSourceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("precomputedInferenceSourceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEDROCK_MODEL_IDENTIFIERS_FIELD, PRECOMPUTED_INFERENCE_SOURCE_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationModelConfigSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> bedrockModelIdentifiers;
    private final List<String> precomputedInferenceSourceIdentifiers;

    private EvaluationModelConfigSummary(BuilderImpl builder) {
        this.bedrockModelIdentifiers = builder.bedrockModelIdentifiers;
        this.precomputedInferenceSourceIdentifiers = builder.precomputedInferenceSourceIdentifiers;
    }

    public final boolean hasBedrockModelIdentifiers() {
        return this.bedrockModelIdentifiers != null && !(this.bedrockModelIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> bedrockModelIdentifiers() {
        return this.bedrockModelIdentifiers;
    }

    public final boolean hasPrecomputedInferenceSourceIdentifiers() {
        return this.precomputedInferenceSourceIdentifiers != null && !(this.precomputedInferenceSourceIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> precomputedInferenceSourceIdentifiers() {
        return this.precomputedInferenceSourceIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBedrockModelIdentifiers() ? this.bedrockModelIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrecomputedInferenceSourceIdentifiers() ? this.precomputedInferenceSourceIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationModelConfigSummary)) {
            return false;
        }
        EvaluationModelConfigSummary other = (EvaluationModelConfigSummary)obj;
        return this.hasBedrockModelIdentifiers() == other.hasBedrockModelIdentifiers() && Objects.equals(this.bedrockModelIdentifiers(), other.bedrockModelIdentifiers()) && this.hasPrecomputedInferenceSourceIdentifiers() == other.hasPrecomputedInferenceSourceIdentifiers() && Objects.equals(this.precomputedInferenceSourceIdentifiers(), other.precomputedInferenceSourceIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationModelConfigSummary").add("BedrockModelIdentifiers", this.hasBedrockModelIdentifiers() ? this.bedrockModelIdentifiers() : null).add("PrecomputedInferenceSourceIdentifiers", this.hasPrecomputedInferenceSourceIdentifiers() ? this.precomputedInferenceSourceIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bedrockModelIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.bedrockModelIdentifiers()));
            }
            case "precomputedInferenceSourceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.precomputedInferenceSourceIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("bedrockModelIdentifiers", BEDROCK_MODEL_IDENTIFIERS_FIELD);
        map.put("precomputedInferenceSourceIdentifiers", PRECOMPUTED_INFERENCE_SOURCE_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationModelConfigSummary, T> g) {
        return obj -> g.apply((EvaluationModelConfigSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> bedrockModelIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> precomputedInferenceSourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationModelConfigSummary model) {
            this.bedrockModelIdentifiers(model.bedrockModelIdentifiers);
            this.precomputedInferenceSourceIdentifiers(model.precomputedInferenceSourceIdentifiers);
        }

        public final Collection<String> getBedrockModelIdentifiers() {
            if (this.bedrockModelIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bedrockModelIdentifiers;
        }

        public final void setBedrockModelIdentifiers(Collection<String> bedrockModelIdentifiers) {
            this.bedrockModelIdentifiers = EvaluationBedrockModelIdentifiersCopier.copy(bedrockModelIdentifiers);
        }

        @Override
        public final Builder bedrockModelIdentifiers(Collection<String> bedrockModelIdentifiers) {
            this.bedrockModelIdentifiers = EvaluationBedrockModelIdentifiersCopier.copy(bedrockModelIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bedrockModelIdentifiers(String ... bedrockModelIdentifiers) {
            this.bedrockModelIdentifiers(Arrays.asList(bedrockModelIdentifiers));
            return this;
        }

        public final Collection<String> getPrecomputedInferenceSourceIdentifiers() {
            if (this.precomputedInferenceSourceIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.precomputedInferenceSourceIdentifiers;
        }

        public final void setPrecomputedInferenceSourceIdentifiers(Collection<String> precomputedInferenceSourceIdentifiers) {
            this.precomputedInferenceSourceIdentifiers = EvaluationPrecomputedInferenceSourceIdentifiersCopier.copy(precomputedInferenceSourceIdentifiers);
        }

        @Override
        public final Builder precomputedInferenceSourceIdentifiers(Collection<String> precomputedInferenceSourceIdentifiers) {
            this.precomputedInferenceSourceIdentifiers = EvaluationPrecomputedInferenceSourceIdentifiersCopier.copy(precomputedInferenceSourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder precomputedInferenceSourceIdentifiers(String ... precomputedInferenceSourceIdentifiers) {
            this.precomputedInferenceSourceIdentifiers(Arrays.asList(precomputedInferenceSourceIdentifiers));
            return this;
        }

        public EvaluationModelConfigSummary build() {
            return new EvaluationModelConfigSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationModelConfigSummary> {
        public Builder bedrockModelIdentifiers(Collection<String> var1);

        public Builder bedrockModelIdentifiers(String ... var1);

        public Builder precomputedInferenceSourceIdentifiers(Collection<String> var1);

        public Builder precomputedInferenceSourceIdentifiers(String ... var1);
    }
}

