/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For a Distillation job, the status details for sub-tasks of the job. Possible statuses for each sub-task include the
 * following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * NotStarted
 * </p>
 * </li>
 * <li>
 * <p>
 * InProgress
 * </p>
 * </li>
 * <li>
 * <p>
 * Completed
 * </p>
 * </li>
 * <li>
 * <p>
 * Stopping
 * </p>
 * </li>
 * <li>
 * <p>
 * Stopped
 * </p>
 * </li>
 * <li>
 * <p>
 * Failed
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatusDetails implements SdkPojo, Serializable, ToCopyableBuilder<StatusDetails.Builder, StatusDetails> {
    private static final SdkField<ValidationDetails> VALIDATION_DETAILS_FIELD = SdkField
            .<ValidationDetails> builder(MarshallingType.SDK_POJO).memberName("validationDetails")
            .getter(getter(StatusDetails::validationDetails)).setter(setter(Builder::validationDetails))
            .constructor(ValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationDetails").build()).build();

    private static final SdkField<DataProcessingDetails> DATA_PROCESSING_DETAILS_FIELD = SdkField
            .<DataProcessingDetails> builder(MarshallingType.SDK_POJO).memberName("dataProcessingDetails")
            .getter(getter(StatusDetails::dataProcessingDetails)).setter(setter(Builder::dataProcessingDetails))
            .constructor(DataProcessingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProcessingDetails").build())
            .build();

    private static final SdkField<TrainingDetails> TRAINING_DETAILS_FIELD = SdkField
            .<TrainingDetails> builder(MarshallingType.SDK_POJO).memberName("trainingDetails")
            .getter(getter(StatusDetails::trainingDetails)).setter(setter(Builder::trainingDetails))
            .constructor(TrainingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_DETAILS_FIELD,
            DATA_PROCESSING_DETAILS_FIELD, TRAINING_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ValidationDetails validationDetails;

    private final DataProcessingDetails dataProcessingDetails;

    private final TrainingDetails trainingDetails;

    private StatusDetails(BuilderImpl builder) {
        this.validationDetails = builder.validationDetails;
        this.dataProcessingDetails = builder.dataProcessingDetails;
        this.trainingDetails = builder.trainingDetails;
    }

    /**
     * <p>
     * The status details for the validation sub-task of the job.
     * </p>
     * 
     * @return The status details for the validation sub-task of the job.
     */
    public final ValidationDetails validationDetails() {
        return validationDetails;
    }

    /**
     * <p>
     * The status details for the data processing sub-task of the job.
     * </p>
     * 
     * @return The status details for the data processing sub-task of the job.
     */
    public final DataProcessingDetails dataProcessingDetails() {
        return dataProcessingDetails;
    }

    /**
     * <p>
     * The status details for the training sub-task of the job.
     * </p>
     * 
     * @return The status details for the training sub-task of the job.
     */
    public final TrainingDetails trainingDetails() {
        return trainingDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(validationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(dataProcessingDetails());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusDetails)) {
            return false;
        }
        StatusDetails other = (StatusDetails) obj;
        return Objects.equals(validationDetails(), other.validationDetails())
                && Objects.equals(dataProcessingDetails(), other.dataProcessingDetails())
                && Objects.equals(trainingDetails(), other.trainingDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatusDetails").add("ValidationDetails", validationDetails())
                .add("DataProcessingDetails", dataProcessingDetails()).add("TrainingDetails", trainingDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "validationDetails":
            return Optional.ofNullable(clazz.cast(validationDetails()));
        case "dataProcessingDetails":
            return Optional.ofNullable(clazz.cast(dataProcessingDetails()));
        case "trainingDetails":
            return Optional.ofNullable(clazz.cast(trainingDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("validationDetails", VALIDATION_DETAILS_FIELD);
        map.put("dataProcessingDetails", DATA_PROCESSING_DETAILS_FIELD);
        map.put("trainingDetails", TRAINING_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatusDetails, T> g) {
        return obj -> g.apply((StatusDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatusDetails> {
        /**
         * <p>
         * The status details for the validation sub-task of the job.
         * </p>
         * 
         * @param validationDetails
         *        The status details for the validation sub-task of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationDetails(ValidationDetails validationDetails);

        /**
         * <p>
         * The status details for the validation sub-task of the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValidationDetails.Builder} avoiding the
         * need to create one manually via {@link ValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #validationDetails(ValidationDetails)}.
         * 
         * @param validationDetails
         *        a consumer that will call methods on {@link ValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationDetails(ValidationDetails)
         */
        default Builder validationDetails(Consumer<ValidationDetails.Builder> validationDetails) {
            return validationDetails(ValidationDetails.builder().applyMutation(validationDetails).build());
        }

        /**
         * <p>
         * The status details for the data processing sub-task of the job.
         * </p>
         * 
         * @param dataProcessingDetails
         *        The status details for the data processing sub-task of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProcessingDetails(DataProcessingDetails dataProcessingDetails);

        /**
         * <p>
         * The status details for the data processing sub-task of the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataProcessingDetails.Builder} avoiding
         * the need to create one manually via {@link DataProcessingDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProcessingDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #dataProcessingDetails(DataProcessingDetails)}.
         * 
         * @param dataProcessingDetails
         *        a consumer that will call methods on {@link DataProcessingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataProcessingDetails(DataProcessingDetails)
         */
        default Builder dataProcessingDetails(Consumer<DataProcessingDetails.Builder> dataProcessingDetails) {
            return dataProcessingDetails(DataProcessingDetails.builder().applyMutation(dataProcessingDetails).build());
        }

        /**
         * <p>
         * The status details for the training sub-task of the job.
         * </p>
         * 
         * @param trainingDetails
         *        The status details for the training sub-task of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDetails(TrainingDetails trainingDetails);

        /**
         * <p>
         * The status details for the training sub-task of the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainingDetails.Builder} avoiding the
         * need to create one manually via {@link TrainingDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainingDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingDetails(TrainingDetails)}.
         * 
         * @param trainingDetails
         *        a consumer that will call methods on {@link TrainingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingDetails(TrainingDetails)
         */
        default Builder trainingDetails(Consumer<TrainingDetails.Builder> trainingDetails) {
            return trainingDetails(TrainingDetails.builder().applyMutation(trainingDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ValidationDetails validationDetails;

        private DataProcessingDetails dataProcessingDetails;

        private TrainingDetails trainingDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusDetails model) {
            validationDetails(model.validationDetails);
            dataProcessingDetails(model.dataProcessingDetails);
            trainingDetails(model.trainingDetails);
        }

        public final ValidationDetails.Builder getValidationDetails() {
            return validationDetails != null ? validationDetails.toBuilder() : null;
        }

        public final void setValidationDetails(ValidationDetails.BuilderImpl validationDetails) {
            this.validationDetails = validationDetails != null ? validationDetails.build() : null;
        }

        @Override
        public final Builder validationDetails(ValidationDetails validationDetails) {
            this.validationDetails = validationDetails;
            return this;
        }

        public final DataProcessingDetails.Builder getDataProcessingDetails() {
            return dataProcessingDetails != null ? dataProcessingDetails.toBuilder() : null;
        }

        public final void setDataProcessingDetails(DataProcessingDetails.BuilderImpl dataProcessingDetails) {
            this.dataProcessingDetails = dataProcessingDetails != null ? dataProcessingDetails.build() : null;
        }

        @Override
        public final Builder dataProcessingDetails(DataProcessingDetails dataProcessingDetails) {
            this.dataProcessingDetails = dataProcessingDetails;
            return this;
        }

        public final TrainingDetails.Builder getTrainingDetails() {
            return trainingDetails != null ? trainingDetails.toBuilder() : null;
        }

        public final void setTrainingDetails(TrainingDetails.BuilderImpl trainingDetails) {
            this.trainingDetails = trainingDetails != null ? trainingDetails.build() : null;
        }

        @Override
        public final Builder trainingDetails(TrainingDetails trainingDetails) {
            this.trainingDetails = trainingDetails;
            return this;
        }

        @Override
        public StatusDetails build() {
            return new StatusDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
