/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details for retrieving information from a knowledge base.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveConfig implements SdkPojo, Serializable, ToCopyableBuilder<RetrieveConfig.Builder, RetrieveConfig> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(RetrieveConfig::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<KnowledgeBaseRetrievalConfiguration> KNOWLEDGE_BASE_RETRIEVAL_CONFIGURATION_FIELD = SdkField
            .<KnowledgeBaseRetrievalConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("knowledgeBaseRetrievalConfiguration")
            .getter(getter(RetrieveConfig::knowledgeBaseRetrievalConfiguration))
            .setter(setter(Builder::knowledgeBaseRetrievalConfiguration))
            .constructor(KnowledgeBaseRetrievalConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("knowledgeBaseRetrievalConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            KNOWLEDGE_BASE_RETRIEVAL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String knowledgeBaseId;

    private final KnowledgeBaseRetrievalConfiguration knowledgeBaseRetrievalConfiguration;

    private RetrieveConfig(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.knowledgeBaseRetrievalConfiguration = builder.knowledgeBaseRetrievalConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base.
     * </p>
     * 
     * @return The unique identifier of the knowledge base.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * Contains configuration details for knowledge base retrieval.
     * </p>
     * 
     * @return Contains configuration details for knowledge base retrieval.
     */
    public final KnowledgeBaseRetrievalConfiguration knowledgeBaseRetrievalConfiguration() {
        return knowledgeBaseRetrievalConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseRetrievalConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveConfig)) {
            return false;
        }
        RetrieveConfig other = (RetrieveConfig) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(knowledgeBaseRetrievalConfiguration(), other.knowledgeBaseRetrievalConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrieveConfig").add("KnowledgeBaseId", knowledgeBaseId())
                .add("KnowledgeBaseRetrievalConfiguration", knowledgeBaseRetrievalConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "knowledgeBaseRetrievalConfiguration":
            return Optional.ofNullable(clazz.cast(knowledgeBaseRetrievalConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("knowledgeBaseRetrievalConfiguration", KNOWLEDGE_BASE_RETRIEVAL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrieveConfig, T> g) {
        return obj -> g.apply((RetrieveConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrieveConfig> {
        /**
         * <p>
         * The unique identifier of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * Contains configuration details for knowledge base retrieval.
         * </p>
         * 
         * @param knowledgeBaseRetrievalConfiguration
         *        Contains configuration details for knowledge base retrieval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseRetrievalConfiguration(KnowledgeBaseRetrievalConfiguration knowledgeBaseRetrievalConfiguration);

        /**
         * <p>
         * Contains configuration details for knowledge base retrieval.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KnowledgeBaseRetrievalConfiguration.Builder} avoiding the need to create one manually via
         * {@link KnowledgeBaseRetrievalConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseRetrievalConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #knowledgeBaseRetrievalConfiguration(KnowledgeBaseRetrievalConfiguration)}.
         * 
         * @param knowledgeBaseRetrievalConfiguration
         *        a consumer that will call methods on {@link KnowledgeBaseRetrievalConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseRetrievalConfiguration(KnowledgeBaseRetrievalConfiguration)
         */
        default Builder knowledgeBaseRetrievalConfiguration(
                Consumer<KnowledgeBaseRetrievalConfiguration.Builder> knowledgeBaseRetrievalConfiguration) {
            return knowledgeBaseRetrievalConfiguration(KnowledgeBaseRetrievalConfiguration.builder()
                    .applyMutation(knowledgeBaseRetrievalConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private KnowledgeBaseRetrievalConfiguration knowledgeBaseRetrievalConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveConfig model) {
            knowledgeBaseId(model.knowledgeBaseId);
            knowledgeBaseRetrievalConfiguration(model.knowledgeBaseRetrievalConfiguration);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final KnowledgeBaseRetrievalConfiguration.Builder getKnowledgeBaseRetrievalConfiguration() {
            return knowledgeBaseRetrievalConfiguration != null ? knowledgeBaseRetrievalConfiguration.toBuilder() : null;
        }

        public final void setKnowledgeBaseRetrievalConfiguration(
                KnowledgeBaseRetrievalConfiguration.BuilderImpl knowledgeBaseRetrievalConfiguration) {
            this.knowledgeBaseRetrievalConfiguration = knowledgeBaseRetrievalConfiguration != null ? knowledgeBaseRetrievalConfiguration
                    .build() : null;
        }

        @Override
        public final Builder knowledgeBaseRetrievalConfiguration(
                KnowledgeBaseRetrievalConfiguration knowledgeBaseRetrievalConfiguration) {
            this.knowledgeBaseRetrievalConfiguration = knowledgeBaseRetrievalConfiguration;
            return this;
        }

        @Override
        public RetrieveConfig build() {
            return new RetrieveConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
