/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details for retrieving information from a knowledge base and generating responses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseConfig.Builder, KnowledgeBaseConfig> {
    private static final SdkField<RetrieveConfig> RETRIEVE_CONFIG_FIELD = SdkField
            .<RetrieveConfig> builder(MarshallingType.SDK_POJO).memberName("retrieveConfig")
            .getter(getter(KnowledgeBaseConfig::retrieveConfig)).setter(setter(Builder::retrieveConfig))
            .constructor(RetrieveConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieveConfig").build()).build();

    private static final SdkField<RetrieveAndGenerateConfiguration> RETRIEVE_AND_GENERATE_CONFIG_FIELD = SdkField
            .<RetrieveAndGenerateConfiguration> builder(MarshallingType.SDK_POJO).memberName("retrieveAndGenerateConfig")
            .getter(getter(KnowledgeBaseConfig::retrieveAndGenerateConfig)).setter(setter(Builder::retrieveAndGenerateConfig))
            .constructor(RetrieveAndGenerateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieveAndGenerateConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVE_CONFIG_FIELD,
            RETRIEVE_AND_GENERATE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RetrieveConfig retrieveConfig;

    private final RetrieveAndGenerateConfiguration retrieveAndGenerateConfig;

    private final Type type;

    private KnowledgeBaseConfig(BuilderImpl builder) {
        this.retrieveConfig = builder.retrieveConfig;
        this.retrieveAndGenerateConfig = builder.retrieveAndGenerateConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains configuration details for retrieving information from a knowledge base.
     * </p>
     * 
     * @return Contains configuration details for retrieving information from a knowledge base.
     */
    public final RetrieveConfig retrieveConfig() {
        return retrieveConfig;
    }

    /**
     * <p>
     * Contains configuration details for retrieving information from a knowledge base and generating responses.
     * </p>
     * 
     * @return Contains configuration details for retrieving information from a knowledge base and generating responses.
     */
    public final RetrieveAndGenerateConfiguration retrieveAndGenerateConfig() {
        return retrieveAndGenerateConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retrieveConfig());
        hashCode = 31 * hashCode + Objects.hashCode(retrieveAndGenerateConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseConfig)) {
            return false;
        }
        KnowledgeBaseConfig other = (KnowledgeBaseConfig) obj;
        return Objects.equals(retrieveConfig(), other.retrieveConfig())
                && Objects.equals(retrieveAndGenerateConfig(), other.retrieveAndGenerateConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseConfig").add("RetrieveConfig", retrieveConfig())
                .add("RetrieveAndGenerateConfig", retrieveAndGenerateConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "retrieveConfig":
            return Optional.ofNullable(clazz.cast(retrieveConfig()));
        case "retrieveAndGenerateConfig":
            return Optional.ofNullable(clazz.cast(retrieveAndGenerateConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #retrieveConfig()} initialized to the given value.
     *
     * <p>
     * Contains configuration details for retrieving information from a knowledge base.
     * </p>
     * 
     * @param retrieveConfig
     *        Contains configuration details for retrieving information from a knowledge base.
     */
    public static KnowledgeBaseConfig fromRetrieveConfig(RetrieveConfig retrieveConfig) {
        return builder().retrieveConfig(retrieveConfig).build();
    }

    /**
     * Create an instance of this class with {@link #retrieveConfig()} initialized to the given value.
     *
     * <p>
     * Contains configuration details for retrieving information from a knowledge base.
     * </p>
     * 
     * @param retrieveConfig
     *        Contains configuration details for retrieving information from a knowledge base.
     */
    public static KnowledgeBaseConfig fromRetrieveConfig(Consumer<RetrieveConfig.Builder> retrieveConfig) {
        RetrieveConfig.Builder builder = RetrieveConfig.builder();
        retrieveConfig.accept(builder);
        return fromRetrieveConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #retrieveAndGenerateConfig()} initialized to the given value.
     *
     * <p>
     * Contains configuration details for retrieving information from a knowledge base and generating responses.
     * </p>
     * 
     * @param retrieveAndGenerateConfig
     *        Contains configuration details for retrieving information from a knowledge base and generating responses.
     */
    public static KnowledgeBaseConfig fromRetrieveAndGenerateConfig(RetrieveAndGenerateConfiguration retrieveAndGenerateConfig) {
        return builder().retrieveAndGenerateConfig(retrieveAndGenerateConfig).build();
    }

    /**
     * Create an instance of this class with {@link #retrieveAndGenerateConfig()} initialized to the given value.
     *
     * <p>
     * Contains configuration details for retrieving information from a knowledge base and generating responses.
     * </p>
     * 
     * @param retrieveAndGenerateConfig
     *        Contains configuration details for retrieving information from a knowledge base and generating responses.
     */
    public static KnowledgeBaseConfig fromRetrieveAndGenerateConfig(
            Consumer<RetrieveAndGenerateConfiguration.Builder> retrieveAndGenerateConfig) {
        RetrieveAndGenerateConfiguration.Builder builder = RetrieveAndGenerateConfiguration.builder();
        retrieveAndGenerateConfig.accept(builder);
        return fromRetrieveAndGenerateConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("retrieveConfig", RETRIEVE_CONFIG_FIELD);
        map.put("retrieveAndGenerateConfig", RETRIEVE_AND_GENERATE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseConfig, T> g) {
        return obj -> g.apply((KnowledgeBaseConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseConfig> {
        /**
         * <p>
         * Contains configuration details for retrieving information from a knowledge base.
         * </p>
         * 
         * @param retrieveConfig
         *        Contains configuration details for retrieving information from a knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieveConfig(RetrieveConfig retrieveConfig);

        /**
         * <p>
         * Contains configuration details for retrieving information from a knowledge base.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrieveConfig.Builder} avoiding the need
         * to create one manually via {@link RetrieveConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrieveConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #retrieveConfig(RetrieveConfig)}.
         * 
         * @param retrieveConfig
         *        a consumer that will call methods on {@link RetrieveConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrieveConfig(RetrieveConfig)
         */
        default Builder retrieveConfig(Consumer<RetrieveConfig.Builder> retrieveConfig) {
            return retrieveConfig(RetrieveConfig.builder().applyMutation(retrieveConfig).build());
        }

        /**
         * <p>
         * Contains configuration details for retrieving information from a knowledge base and generating responses.
         * </p>
         * 
         * @param retrieveAndGenerateConfig
         *        Contains configuration details for retrieving information from a knowledge base and generating
         *        responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieveAndGenerateConfig(RetrieveAndGenerateConfiguration retrieveAndGenerateConfig);

        /**
         * <p>
         * Contains configuration details for retrieving information from a knowledge base and generating responses.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrieveAndGenerateConfiguration.Builder}
         * avoiding the need to create one manually via {@link RetrieveAndGenerateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrieveAndGenerateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #retrieveAndGenerateConfig(RetrieveAndGenerateConfiguration)}.
         * 
         * @param retrieveAndGenerateConfig
         *        a consumer that will call methods on {@link RetrieveAndGenerateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrieveAndGenerateConfig(RetrieveAndGenerateConfiguration)
         */
        default Builder retrieveAndGenerateConfig(Consumer<RetrieveAndGenerateConfiguration.Builder> retrieveAndGenerateConfig) {
            return retrieveAndGenerateConfig(RetrieveAndGenerateConfiguration.builder().applyMutation(retrieveAndGenerateConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RetrieveConfig retrieveConfig;

        private RetrieveAndGenerateConfiguration retrieveAndGenerateConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseConfig model) {
            retrieveConfig(model.retrieveConfig);
            retrieveAndGenerateConfig(model.retrieveAndGenerateConfig);
        }

        public final RetrieveConfig.Builder getRetrieveConfig() {
            return retrieveConfig != null ? retrieveConfig.toBuilder() : null;
        }

        public final void setRetrieveConfig(RetrieveConfig.BuilderImpl retrieveConfig) {
            Object oldValue = this.retrieveConfig;
            this.retrieveConfig = retrieveConfig != null ? retrieveConfig.build() : null;
            handleUnionValueChange(Type.RETRIEVE_CONFIG, oldValue, this.retrieveConfig);
        }

        @Override
        public final Builder retrieveConfig(RetrieveConfig retrieveConfig) {
            Object oldValue = this.retrieveConfig;
            this.retrieveConfig = retrieveConfig;
            handleUnionValueChange(Type.RETRIEVE_CONFIG, oldValue, this.retrieveConfig);
            return this;
        }

        public final RetrieveAndGenerateConfiguration.Builder getRetrieveAndGenerateConfig() {
            return retrieveAndGenerateConfig != null ? retrieveAndGenerateConfig.toBuilder() : null;
        }

        public final void setRetrieveAndGenerateConfig(RetrieveAndGenerateConfiguration.BuilderImpl retrieveAndGenerateConfig) {
            Object oldValue = this.retrieveAndGenerateConfig;
            this.retrieveAndGenerateConfig = retrieveAndGenerateConfig != null ? retrieveAndGenerateConfig.build() : null;
            handleUnionValueChange(Type.RETRIEVE_AND_GENERATE_CONFIG, oldValue, this.retrieveAndGenerateConfig);
        }

        @Override
        public final Builder retrieveAndGenerateConfig(RetrieveAndGenerateConfiguration retrieveAndGenerateConfig) {
            Object oldValue = this.retrieveAndGenerateConfig;
            this.retrieveAndGenerateConfig = retrieveAndGenerateConfig;
            handleUnionValueChange(Type.RETRIEVE_AND_GENERATE_CONFIG, oldValue, this.retrieveAndGenerateConfig);
            return this;
        }

        @Override
        public KnowledgeBaseConfig build() {
            return new KnowledgeBaseConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see KnowledgeBaseConfig#type()
     */
    public enum Type {
        RETRIEVE_CONFIG,

        RETRIEVE_AND_GENERATE_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
