/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The regular expression configured for the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailRegex implements SdkPojo, Serializable, ToCopyableBuilder<GuardrailRegex.Builder, GuardrailRegex> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GuardrailRegex::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GuardrailRegex::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("pattern")
            .getter(getter(GuardrailRegex::pattern)).setter(setter(Builder::pattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pattern").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(GuardrailRegex::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> INPUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputAction").getter(getter(GuardrailRegex::inputActionAsString)).setter(setter(Builder::inputAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAction").build()).build();

    private static final SdkField<String> OUTPUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputAction").getter(getter(GuardrailRegex::outputActionAsString))
            .setter(setter(Builder::outputAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputAction").build()).build();

    private static final SdkField<Boolean> INPUT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("inputEnabled").getter(getter(GuardrailRegex::inputEnabled)).setter(setter(Builder::inputEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputEnabled").build()).build();

    private static final SdkField<Boolean> OUTPUT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("outputEnabled").getter(getter(GuardrailRegex::outputEnabled)).setter(setter(Builder::outputEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            PATTERN_FIELD, ACTION_FIELD, INPUT_ACTION_FIELD, OUTPUT_ACTION_FIELD, INPUT_ENABLED_FIELD, OUTPUT_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String pattern;

    private final String action;

    private final String inputAction;

    private final String outputAction;

    private final Boolean inputEnabled;

    private final Boolean outputEnabled;

    private GuardrailRegex(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.pattern = builder.pattern;
        this.action = builder.action;
        this.inputAction = builder.inputAction;
        this.outputAction = builder.outputAction;
        this.inputEnabled = builder.inputEnabled;
        this.outputEnabled = builder.outputEnabled;
    }

    /**
     * <p>
     * The name of the regular expression for the guardrail.
     * </p>
     * 
     * @return The name of the regular expression for the guardrail.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the regular expression for the guardrail.
     * </p>
     * 
     * @return The description of the regular expression for the guardrail.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The pattern of the regular expression configured for the guardrail.
     * </p>
     * 
     * @return The pattern of the regular expression configured for the guardrail.
     */
    public final String pattern() {
        return pattern;
    }

    /**
     * <p>
     * The action taken when a match to the regular expression is detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action taken when a match to the regular expression is detected.
     * @see GuardrailSensitiveInformationAction
     */
    public final GuardrailSensitiveInformationAction action() {
        return GuardrailSensitiveInformationAction.fromValue(action);
    }

    /**
     * <p>
     * The action taken when a match to the regular expression is detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action taken when a match to the regular expression is detected.
     * @see GuardrailSensitiveInformationAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The action to take when harmful content is detected in the input. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputAction} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #inputActionAsString}.
     * </p>
     * 
     * @return The action to take when harmful content is detected in the input. Supported values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailSensitiveInformationAction
     */
    public final GuardrailSensitiveInformationAction inputAction() {
        return GuardrailSensitiveInformationAction.fromValue(inputAction);
    }

    /**
     * <p>
     * The action to take when harmful content is detected in the input. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputAction} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #inputActionAsString}.
     * </p>
     * 
     * @return The action to take when harmful content is detected in the input. Supported values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailSensitiveInformationAction
     */
    public final String inputActionAsString() {
        return inputAction;
    }

    /**
     * <p>
     * The action to take when harmful content is detected in the output. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputAction} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #outputActionAsString}.
     * </p>
     * 
     * @return The action to take when harmful content is detected in the output. Supported values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailSensitiveInformationAction
     */
    public final GuardrailSensitiveInformationAction outputAction() {
        return GuardrailSensitiveInformationAction.fromValue(outputAction);
    }

    /**
     * <p>
     * The action to take when harmful content is detected in the output. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputAction} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #outputActionAsString}.
     * </p>
     * 
     * @return The action to take when harmful content is detected in the output. Supported values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailSensitiveInformationAction
     */
    public final String outputActionAsString() {
        return outputAction;
    }

    /**
     * <p>
     * Indicates whether guardrail evaluation is enabled on the input. When disabled, you aren't charged for the
     * evaluation. The evaluation doesn't appear in the response.
     * </p>
     * 
     * @return Indicates whether guardrail evaluation is enabled on the input. When disabled, you aren't charged for the
     *         evaluation. The evaluation doesn't appear in the response.
     */
    public final Boolean inputEnabled() {
        return inputEnabled;
    }

    /**
     * <p>
     * Indicates whether guardrail evaluation is enabled on the output. When disabled, you aren't charged for the
     * evaluation. The evaluation doesn't appear in the response.
     * </p>
     * 
     * @return Indicates whether guardrail evaluation is enabled on the output. When disabled, you aren't charged for
     *         the evaluation. The evaluation doesn't appear in the response.
     */
    public final Boolean outputEnabled() {
        return outputEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(pattern());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(outputEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailRegex)) {
            return false;
        }
        GuardrailRegex other = (GuardrailRegex) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(pattern(), other.pattern()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(inputActionAsString(), other.inputActionAsString())
                && Objects.equals(outputActionAsString(), other.outputActionAsString())
                && Objects.equals(inputEnabled(), other.inputEnabled()) && Objects.equals(outputEnabled(), other.outputEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailRegex").add("Name", name()).add("Description", description()).add("Pattern", pattern())
                .add("Action", actionAsString()).add("InputAction", inputActionAsString())
                .add("OutputAction", outputActionAsString()).add("InputEnabled", inputEnabled())
                .add("OutputEnabled", outputEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "pattern":
            return Optional.ofNullable(clazz.cast(pattern()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "inputAction":
            return Optional.ofNullable(clazz.cast(inputActionAsString()));
        case "outputAction":
            return Optional.ofNullable(clazz.cast(outputActionAsString()));
        case "inputEnabled":
            return Optional.ofNullable(clazz.cast(inputEnabled()));
        case "outputEnabled":
            return Optional.ofNullable(clazz.cast(outputEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("pattern", PATTERN_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("inputAction", INPUT_ACTION_FIELD);
        map.put("outputAction", OUTPUT_ACTION_FIELD);
        map.put("inputEnabled", INPUT_ENABLED_FIELD);
        map.put("outputEnabled", OUTPUT_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailRegex, T> g) {
        return obj -> g.apply((GuardrailRegex) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailRegex> {
        /**
         * <p>
         * The name of the regular expression for the guardrail.
         * </p>
         * 
         * @param name
         *        The name of the regular expression for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the regular expression for the guardrail.
         * </p>
         * 
         * @param description
         *        The description of the regular expression for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The pattern of the regular expression configured for the guardrail.
         * </p>
         * 
         * @param pattern
         *        The pattern of the regular expression configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pattern(String pattern);

        /**
         * <p>
         * The action taken when a match to the regular expression is detected.
         * </p>
         * 
         * @param action
         *        The action taken when a match to the regular expression is detected.
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action taken when a match to the regular expression is detected.
         * </p>
         * 
         * @param action
         *        The action taken when a match to the regular expression is detected.
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder action(GuardrailSensitiveInformationAction action);

        /**
         * <p>
         * The action to take when harmful content is detected in the input. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputAction
         *        The action to take when harmful content is detected in the input. Supported values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder inputAction(String inputAction);

        /**
         * <p>
         * The action to take when harmful content is detected in the input. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputAction
         *        The action to take when harmful content is detected in the input. Supported values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder inputAction(GuardrailSensitiveInformationAction inputAction);

        /**
         * <p>
         * The action to take when harmful content is detected in the output. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param outputAction
         *        The action to take when harmful content is detected in the output. Supported values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder outputAction(String outputAction);

        /**
         * <p>
         * The action to take when harmful content is detected in the output. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param outputAction
         *        The action to take when harmful content is detected in the output. Supported values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder outputAction(GuardrailSensitiveInformationAction outputAction);

        /**
         * <p>
         * Indicates whether guardrail evaluation is enabled on the input. When disabled, you aren't charged for the
         * evaluation. The evaluation doesn't appear in the response.
         * </p>
         * 
         * @param inputEnabled
         *        Indicates whether guardrail evaluation is enabled on the input. When disabled, you aren't charged for
         *        the evaluation. The evaluation doesn't appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputEnabled(Boolean inputEnabled);

        /**
         * <p>
         * Indicates whether guardrail evaluation is enabled on the output. When disabled, you aren't charged for the
         * evaluation. The evaluation doesn't appear in the response.
         * </p>
         * 
         * @param outputEnabled
         *        Indicates whether guardrail evaluation is enabled on the output. When disabled, you aren't charged for
         *        the evaluation. The evaluation doesn't appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputEnabled(Boolean outputEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String pattern;

        private String action;

        private String inputAction;

        private String outputAction;

        private Boolean inputEnabled;

        private Boolean outputEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailRegex model) {
            name(model.name);
            description(model.description);
            pattern(model.pattern);
            action(model.action);
            inputAction(model.inputAction);
            outputAction(model.outputAction);
            inputEnabled(model.inputEnabled);
            outputEnabled(model.outputEnabled);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPattern() {
            return pattern;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailSensitiveInformationAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getInputAction() {
            return inputAction;
        }

        public final void setInputAction(String inputAction) {
            this.inputAction = inputAction;
        }

        @Override
        public final Builder inputAction(String inputAction) {
            this.inputAction = inputAction;
            return this;
        }

        @Override
        public final Builder inputAction(GuardrailSensitiveInformationAction inputAction) {
            this.inputAction(inputAction == null ? null : inputAction.toString());
            return this;
        }

        public final String getOutputAction() {
            return outputAction;
        }

        public final void setOutputAction(String outputAction) {
            this.outputAction = outputAction;
        }

        @Override
        public final Builder outputAction(String outputAction) {
            this.outputAction = outputAction;
            return this;
        }

        @Override
        public final Builder outputAction(GuardrailSensitiveInformationAction outputAction) {
            this.outputAction(outputAction == null ? null : outputAction.toString());
            return this;
        }

        public final Boolean getInputEnabled() {
            return inputEnabled;
        }

        public final void setInputEnabled(Boolean inputEnabled) {
            this.inputEnabled = inputEnabled;
        }

        @Override
        public final Builder inputEnabled(Boolean inputEnabled) {
            this.inputEnabled = inputEnabled;
            return this;
        }

        public final Boolean getOutputEnabled() {
            return outputEnabled;
        }

        public final void setOutputEnabled(Boolean outputEnabled) {
            this.outputEnabled = outputEnabled;
        }

        @Override
        public final Builder outputEnabled(Boolean outputEnabled) {
            this.outputEnabled = outputEnabled;
            return this;
        }

        @Override
        public GuardrailRegex build() {
            return new GuardrailRegex(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
