/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.EvaluationPrecomputedRagSourceConfig;
import software.amazon.awssdk.services.bedrock.model.KnowledgeBaseConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RAGConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RAGConfig> {
    private static final SdkField<KnowledgeBaseConfig> KNOWLEDGE_BASE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("knowledgeBaseConfig").getter(RAGConfig.getter(RAGConfig::knowledgeBaseConfig)).setter(RAGConfig.setter(Builder::knowledgeBaseConfig)).constructor(KnowledgeBaseConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseConfig").build()}).build();
    private static final SdkField<EvaluationPrecomputedRagSourceConfig> PRECOMPUTED_RAG_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("precomputedRagSourceConfig").getter(RAGConfig.getter(RAGConfig::precomputedRagSourceConfig)).setter(RAGConfig.setter(Builder::precomputedRagSourceConfig)).constructor(EvaluationPrecomputedRagSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("precomputedRagSourceConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_CONFIG_FIELD, PRECOMPUTED_RAG_SOURCE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RAGConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final KnowledgeBaseConfig knowledgeBaseConfig;
    private final EvaluationPrecomputedRagSourceConfig precomputedRagSourceConfig;
    private final Type type;

    private RAGConfig(BuilderImpl builder) {
        this.knowledgeBaseConfig = builder.knowledgeBaseConfig;
        this.precomputedRagSourceConfig = builder.precomputedRagSourceConfig;
        this.type = builder.type;
    }

    public final KnowledgeBaseConfig knowledgeBaseConfig() {
        return this.knowledgeBaseConfig;
    }

    public final EvaluationPrecomputedRagSourceConfig precomputedRagSourceConfig() {
        return this.precomputedRagSourceConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.precomputedRagSourceConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RAGConfig)) {
            return false;
        }
        RAGConfig other = (RAGConfig)obj;
        return Objects.equals(this.knowledgeBaseConfig(), other.knowledgeBaseConfig()) && Objects.equals(this.precomputedRagSourceConfig(), other.precomputedRagSourceConfig());
    }

    public final String toString() {
        return ToString.builder((String)"RAGConfig").add("KnowledgeBaseConfig", (Object)this.knowledgeBaseConfig()).add("PrecomputedRagSourceConfig", (Object)this.precomputedRagSourceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseConfig": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseConfig()));
            }
            case "precomputedRagSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.precomputedRagSourceConfig()));
            }
        }
        return Optional.empty();
    }

    public static RAGConfig fromKnowledgeBaseConfig(KnowledgeBaseConfig knowledgeBaseConfig) {
        return (RAGConfig)RAGConfig.builder().knowledgeBaseConfig(knowledgeBaseConfig).build();
    }

    public static RAGConfig fromKnowledgeBaseConfig(Consumer<KnowledgeBaseConfig.Builder> knowledgeBaseConfig) {
        KnowledgeBaseConfig.Builder builder = KnowledgeBaseConfig.builder();
        knowledgeBaseConfig.accept(builder);
        return RAGConfig.fromKnowledgeBaseConfig((KnowledgeBaseConfig)builder.build());
    }

    public static RAGConfig fromPrecomputedRagSourceConfig(EvaluationPrecomputedRagSourceConfig precomputedRagSourceConfig) {
        return (RAGConfig)RAGConfig.builder().precomputedRagSourceConfig(precomputedRagSourceConfig).build();
    }

    public static RAGConfig fromPrecomputedRagSourceConfig(Consumer<EvaluationPrecomputedRagSourceConfig.Builder> precomputedRagSourceConfig) {
        EvaluationPrecomputedRagSourceConfig.Builder builder = EvaluationPrecomputedRagSourceConfig.builder();
        precomputedRagSourceConfig.accept(builder);
        return RAGConfig.fromPrecomputedRagSourceConfig((EvaluationPrecomputedRagSourceConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("knowledgeBaseConfig", KNOWLEDGE_BASE_CONFIG_FIELD);
        map.put("precomputedRagSourceConfig", PRECOMPUTED_RAG_SOURCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RAGConfig, T> g) {
        return obj -> g.apply((RAGConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        KNOWLEDGE_BASE_CONFIG,
        PRECOMPUTED_RAG_SOURCE_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private KnowledgeBaseConfig knowledgeBaseConfig;
        private EvaluationPrecomputedRagSourceConfig precomputedRagSourceConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RAGConfig model) {
            this.knowledgeBaseConfig(model.knowledgeBaseConfig);
            this.precomputedRagSourceConfig(model.precomputedRagSourceConfig);
        }

        public final KnowledgeBaseConfig.Builder getKnowledgeBaseConfig() {
            return this.knowledgeBaseConfig != null ? this.knowledgeBaseConfig.toBuilder() : null;
        }

        public final void setKnowledgeBaseConfig(KnowledgeBaseConfig.BuilderImpl knowledgeBaseConfig) {
            KnowledgeBaseConfig oldValue = this.knowledgeBaseConfig;
            this.knowledgeBaseConfig = knowledgeBaseConfig != null ? knowledgeBaseConfig.build() : null;
            this.handleUnionValueChange(Type.KNOWLEDGE_BASE_CONFIG, oldValue, this.knowledgeBaseConfig);
        }

        @Override
        public final Builder knowledgeBaseConfig(KnowledgeBaseConfig knowledgeBaseConfig) {
            KnowledgeBaseConfig oldValue = this.knowledgeBaseConfig;
            this.knowledgeBaseConfig = knowledgeBaseConfig;
            this.handleUnionValueChange(Type.KNOWLEDGE_BASE_CONFIG, oldValue, this.knowledgeBaseConfig);
            return this;
        }

        public final EvaluationPrecomputedRagSourceConfig.Builder getPrecomputedRagSourceConfig() {
            return this.precomputedRagSourceConfig != null ? this.precomputedRagSourceConfig.toBuilder() : null;
        }

        public final void setPrecomputedRagSourceConfig(EvaluationPrecomputedRagSourceConfig.BuilderImpl precomputedRagSourceConfig) {
            EvaluationPrecomputedRagSourceConfig oldValue = this.precomputedRagSourceConfig;
            this.precomputedRagSourceConfig = precomputedRagSourceConfig != null ? precomputedRagSourceConfig.build() : null;
            this.handleUnionValueChange(Type.PRECOMPUTED_RAG_SOURCE_CONFIG, oldValue, this.precomputedRagSourceConfig);
        }

        @Override
        public final Builder precomputedRagSourceConfig(EvaluationPrecomputedRagSourceConfig precomputedRagSourceConfig) {
            EvaluationPrecomputedRagSourceConfig oldValue = this.precomputedRagSourceConfig;
            this.precomputedRagSourceConfig = precomputedRagSourceConfig;
            this.handleUnionValueChange(Type.PRECOMPUTED_RAG_SOURCE_CONFIG, oldValue, this.precomputedRagSourceConfig);
            return this;
        }

        public RAGConfig build() {
            return new RAGConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RAGConfig> {
        public Builder knowledgeBaseConfig(KnowledgeBaseConfig var1);

        default public Builder knowledgeBaseConfig(Consumer<KnowledgeBaseConfig.Builder> knowledgeBaseConfig) {
            return this.knowledgeBaseConfig((KnowledgeBaseConfig)((KnowledgeBaseConfig.Builder)KnowledgeBaseConfig.builder().applyMutation(knowledgeBaseConfig)).build());
        }

        public Builder precomputedRagSourceConfig(EvaluationPrecomputedRagSourceConfig var1);

        default public Builder precomputedRagSourceConfig(Consumer<EvaluationPrecomputedRagSourceConfig.Builder> precomputedRagSourceConfig) {
            return this.precomputedRagSourceConfig((EvaluationPrecomputedRagSourceConfig)((EvaluationPrecomputedRagSourceConfig.Builder)EvaluationPrecomputedRagSourceConfig.builder().applyMutation(precomputedRagSourceConfig)).build());
        }
    }
}

