/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.CustomizationType;
import software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus;
import software.amazon.awssdk.services.bedrock.model.StatusDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelCustomizationJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelCustomizationJobSummary> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(ModelCustomizationJobSummary.getter(ModelCustomizationJobSummary::jobArn)).setter(ModelCustomizationJobSummary.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> BASE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseModelArn").getter(ModelCustomizationJobSummary.getter(ModelCustomizationJobSummary::baseModelArn)).setter(ModelCustomizationJobSummary.setter(Builder::baseModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseModelArn").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(ModelCustomizationJobSummary.getter(ModelCustomizationJobSummary::jobName)).setter(ModelCustomizationJobSummary.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ModelCustomizationJobSummary.getter(ModelCustomizationJobSummary::statusAsString)).setter(ModelCustomizationJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(ModelCustomizationJobSummary.getter(ModelCustomizationJobSummary::lastModifiedTime)).setter(ModelCustomizationJobSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusDetails").getter(ModelCustomizationJobSummary.getter(ModelCustomizationJobSummary::statusDetails)).setter(ModelCustomizationJobSummary.setter(Builder::statusDetails)).constructor(StatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ModelCustomizationJobSummary.getter(ModelCustomizationJobSummary::creationTime)).setter(ModelCustomizationJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ModelCustomizationJobSummary.getter(ModelCustomizationJobSummary::endTime)).setter(ModelCustomizationJobSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CUSTOM_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customModelArn").getter(ModelCustomizationJobSummary.getter(ModelCustomizationJobSummary::customModelArn)).setter(ModelCustomizationJobSummary.setter(Builder::customModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelArn").build()}).build();
    private static final SdkField<String> CUSTOM_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customModelName").getter(ModelCustomizationJobSummary.getter(ModelCustomizationJobSummary::customModelName)).setter(ModelCustomizationJobSummary.setter(Builder::customModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelName").build()}).build();
    private static final SdkField<String> CUSTOMIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customizationType").getter(ModelCustomizationJobSummary.getter(ModelCustomizationJobSummary::customizationTypeAsString)).setter(ModelCustomizationJobSummary.setter(Builder::customizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, BASE_MODEL_ARN_FIELD, JOB_NAME_FIELD, STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, STATUS_DETAILS_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, CUSTOM_MODEL_ARN_FIELD, CUSTOM_MODEL_NAME_FIELD, CUSTOMIZATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelCustomizationJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobArn;
    private final String baseModelArn;
    private final String jobName;
    private final String status;
    private final Instant lastModifiedTime;
    private final StatusDetails statusDetails;
    private final Instant creationTime;
    private final Instant endTime;
    private final String customModelArn;
    private final String customModelName;
    private final String customizationType;

    private ModelCustomizationJobSummary(BuilderImpl builder) {
        this.jobArn = builder.jobArn;
        this.baseModelArn = builder.baseModelArn;
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.statusDetails = builder.statusDetails;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.customModelArn = builder.customModelArn;
        this.customModelName = builder.customModelName;
        this.customizationType = builder.customizationType;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String baseModelArn() {
        return this.baseModelArn;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final ModelCustomizationJobStatus status() {
        return ModelCustomizationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final StatusDetails statusDetails() {
        return this.statusDetails;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String customModelArn() {
        return this.customModelArn;
    }

    public final String customModelName() {
        return this.customModelName;
    }

    public final CustomizationType customizationType() {
        return CustomizationType.fromValue(this.customizationType);
    }

    public final String customizationTypeAsString() {
        return this.customizationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.customModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.customizationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelCustomizationJobSummary)) {
            return false;
        }
        ModelCustomizationJobSummary other = (ModelCustomizationJobSummary)obj;
        return Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.baseModelArn(), other.baseModelArn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.customModelArn(), other.customModelArn()) && Objects.equals(this.customModelName(), other.customModelName()) && Objects.equals(this.customizationTypeAsString(), other.customizationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModelCustomizationJobSummary").add("JobArn", (Object)this.jobArn()).add("BaseModelArn", (Object)this.baseModelArn()).add("JobName", (Object)this.jobName()).add("Status", (Object)this.statusAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("StatusDetails", (Object)this.statusDetails()).add("CreationTime", (Object)this.creationTime()).add("EndTime", (Object)this.endTime()).add("CustomModelArn", (Object)this.customModelArn()).add("CustomModelName", (Object)this.customModelName()).add("CustomizationType", (Object)this.customizationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "baseModelArn": {
                return Optional.ofNullable(clazz.cast(this.baseModelArn()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "customModelArn": {
                return Optional.ofNullable(clazz.cast(this.customModelArn()));
            }
            case "customModelName": {
                return Optional.ofNullable(clazz.cast(this.customModelName()));
            }
            case "customizationType": {
                return Optional.ofNullable(clazz.cast(this.customizationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("baseModelArn", BASE_MODEL_ARN_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("statusDetails", STATUS_DETAILS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("customModelArn", CUSTOM_MODEL_ARN_FIELD);
        map.put("customModelName", CUSTOM_MODEL_NAME_FIELD);
        map.put("customizationType", CUSTOMIZATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelCustomizationJobSummary, T> g) {
        return obj -> g.apply((ModelCustomizationJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobArn;
        private String baseModelArn;
        private String jobName;
        private String status;
        private Instant lastModifiedTime;
        private StatusDetails statusDetails;
        private Instant creationTime;
        private Instant endTime;
        private String customModelArn;
        private String customModelName;
        private String customizationType;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelCustomizationJobSummary model) {
            this.jobArn(model.jobArn);
            this.baseModelArn(model.baseModelArn);
            this.jobName(model.jobName);
            this.status(model.status);
            this.lastModifiedTime(model.lastModifiedTime);
            this.statusDetails(model.statusDetails);
            this.creationTime(model.creationTime);
            this.endTime(model.endTime);
            this.customModelArn(model.customModelArn);
            this.customModelName(model.customModelName);
            this.customizationType(model.customizationType);
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getBaseModelArn() {
            return this.baseModelArn;
        }

        public final void setBaseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
        }

        @Override
        public final Builder baseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelCustomizationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return this.statusDetails != null ? this.statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getCustomModelArn() {
            return this.customModelArn;
        }

        public final void setCustomModelArn(String customModelArn) {
            this.customModelArn = customModelArn;
        }

        @Override
        public final Builder customModelArn(String customModelArn) {
            this.customModelArn = customModelArn;
            return this;
        }

        public final String getCustomModelName() {
            return this.customModelName;
        }

        public final void setCustomModelName(String customModelName) {
            this.customModelName = customModelName;
        }

        @Override
        public final Builder customModelName(String customModelName) {
            this.customModelName = customModelName;
            return this;
        }

        public final String getCustomizationType() {
            return this.customizationType;
        }

        public final void setCustomizationType(String customizationType) {
            this.customizationType = customizationType;
        }

        @Override
        public final Builder customizationType(String customizationType) {
            this.customizationType = customizationType;
            return this;
        }

        @Override
        public final Builder customizationType(CustomizationType customizationType) {
            this.customizationType(customizationType == null ? null : customizationType.toString());
            return this;
        }

        public ModelCustomizationJobSummary build() {
            return new ModelCustomizationJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelCustomizationJobSummary> {
        public Builder jobArn(String var1);

        public Builder baseModelArn(String var1);

        public Builder jobName(String var1);

        public Builder status(String var1);

        public Builder status(ModelCustomizationJobStatus var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder statusDetails(StatusDetails var1);

        default public Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return this.statusDetails((StatusDetails)((StatusDetails.Builder)StatusDetails.builder().applyMutation(statusDetails)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder customModelArn(String var1);

        public Builder customModelName(String var1);

        public Builder customizationType(String var1);

        public Builder customizationType(CustomizationType var1);
    }
}

