/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.ModelCopyJobSummariesCopier;
import software.amazon.awssdk.services.bedrock.model.ModelCopyJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelCopyJobsResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListModelCopyJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListModelCopyJobsResponse.getter(ListModelCopyJobsResponse::nextToken)).setter(ListModelCopyJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ModelCopyJobSummary>> MODEL_COPY_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelCopyJobSummaries").getter(ListModelCopyJobsResponse.getter(ListModelCopyJobsResponse::modelCopyJobSummaries)).setter(ListModelCopyJobsResponse.setter(Builder::modelCopyJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelCopyJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelCopyJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MODEL_COPY_JOB_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListModelCopyJobsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ModelCopyJobSummary> modelCopyJobSummaries;

    private ListModelCopyJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.modelCopyJobSummaries = builder.modelCopyJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasModelCopyJobSummaries() {
        return this.modelCopyJobSummaries != null && !(this.modelCopyJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<ModelCopyJobSummary> modelCopyJobSummaries() {
        return this.modelCopyJobSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelCopyJobSummaries() ? this.modelCopyJobSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelCopyJobsResponse)) {
            return false;
        }
        ListModelCopyJobsResponse other = (ListModelCopyJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasModelCopyJobSummaries() == other.hasModelCopyJobSummaries() && Objects.equals(this.modelCopyJobSummaries(), other.modelCopyJobSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelCopyJobsResponse").add("NextToken", (Object)this.nextToken()).add("ModelCopyJobSummaries", this.hasModelCopyJobSummaries() ? this.modelCopyJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "modelCopyJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.modelCopyJobSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("modelCopyJobSummaries", MODEL_COPY_JOB_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelCopyJobsResponse, T> g) {
        return obj -> g.apply((ListModelCopyJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ModelCopyJobSummary> modelCopyJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelCopyJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.modelCopyJobSummaries(model.modelCopyJobSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ModelCopyJobSummary.Builder> getModelCopyJobSummaries() {
            List<ModelCopyJobSummary.Builder> result = ModelCopyJobSummariesCopier.copyToBuilder(this.modelCopyJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelCopyJobSummaries(Collection<ModelCopyJobSummary.BuilderImpl> modelCopyJobSummaries) {
            this.modelCopyJobSummaries = ModelCopyJobSummariesCopier.copyFromBuilder(modelCopyJobSummaries);
        }

        @Override
        public final Builder modelCopyJobSummaries(Collection<ModelCopyJobSummary> modelCopyJobSummaries) {
            this.modelCopyJobSummaries = ModelCopyJobSummariesCopier.copy(modelCopyJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCopyJobSummaries(ModelCopyJobSummary ... modelCopyJobSummaries) {
            this.modelCopyJobSummaries(Arrays.asList(modelCopyJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCopyJobSummaries(Consumer<ModelCopyJobSummary.Builder> ... modelCopyJobSummaries) {
            this.modelCopyJobSummaries(Stream.of(modelCopyJobSummaries).map(c -> (ModelCopyJobSummary)((ModelCopyJobSummary.Builder)ModelCopyJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListModelCopyJobsResponse build() {
            return new ListModelCopyJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelCopyJobsResponse> {
        public Builder nextToken(String var1);

        public Builder modelCopyJobSummaries(Collection<ModelCopyJobSummary> var1);

        public Builder modelCopyJobSummaries(ModelCopyJobSummary ... var1);

        public Builder modelCopyJobSummaries(Consumer<ModelCopyJobSummary.Builder> ... var1);
    }
}

