/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsRequest;
import software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsResponse;
import software.amazon.awssdk.services.bedrock.model.MarketplaceModelEndpointSummary;

public class ListMarketplaceModelEndpointsIterable
implements SdkIterable<ListMarketplaceModelEndpointsResponse> {
    private final BedrockClient client;
    private final ListMarketplaceModelEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMarketplaceModelEndpointsIterable(BedrockClient client, ListMarketplaceModelEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMarketplaceModelEndpointsResponseFetcher();
    }

    public Iterator<ListMarketplaceModelEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MarketplaceModelEndpointSummary> marketplaceModelEndpoints() {
        Function<ListMarketplaceModelEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.marketplaceModelEndpoints() != null) {
                return response.marketplaceModelEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMarketplaceModelEndpointsResponseFetcher
    implements SyncPageFetcher<ListMarketplaceModelEndpointsResponse> {
        private ListMarketplaceModelEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListMarketplaceModelEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMarketplaceModelEndpointsResponse nextPage(ListMarketplaceModelEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListMarketplaceModelEndpointsIterable.this.client.listMarketplaceModelEndpoints(ListMarketplaceModelEndpointsIterable.this.firstRequest);
            }
            return ListMarketplaceModelEndpointsIterable.this.client.listMarketplaceModelEndpoints((ListMarketplaceModelEndpointsRequest)((Object)ListMarketplaceModelEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

