/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.MarketplaceModelEndpointSummariesCopier;
import software.amazon.awssdk.services.bedrock.model.MarketplaceModelEndpointSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMarketplaceModelEndpointsResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListMarketplaceModelEndpointsResponse> {
    private static final SdkField<List<MarketplaceModelEndpointSummary>> MARKETPLACE_MODEL_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("marketplaceModelEndpoints").getter(ListMarketplaceModelEndpointsResponse.getter(ListMarketplaceModelEndpointsResponse::marketplaceModelEndpoints)).setter(ListMarketplaceModelEndpointsResponse.setter(Builder::marketplaceModelEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marketplaceModelEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MarketplaceModelEndpointSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMarketplaceModelEndpointsResponse.getter(ListMarketplaceModelEndpointsResponse::nextToken)).setter(ListMarketplaceModelEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKETPLACE_MODEL_ENDPOINTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMarketplaceModelEndpointsResponse.memberNameToFieldInitializer();
    private final List<MarketplaceModelEndpointSummary> marketplaceModelEndpoints;
    private final String nextToken;

    private ListMarketplaceModelEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.marketplaceModelEndpoints = builder.marketplaceModelEndpoints;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMarketplaceModelEndpoints() {
        return this.marketplaceModelEndpoints != null && !(this.marketplaceModelEndpoints instanceof SdkAutoConstructList);
    }

    public final List<MarketplaceModelEndpointSummary> marketplaceModelEndpoints() {
        return this.marketplaceModelEndpoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMarketplaceModelEndpoints() ? this.marketplaceModelEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMarketplaceModelEndpointsResponse)) {
            return false;
        }
        ListMarketplaceModelEndpointsResponse other = (ListMarketplaceModelEndpointsResponse)((Object)obj);
        return this.hasMarketplaceModelEndpoints() == other.hasMarketplaceModelEndpoints() && Objects.equals(this.marketplaceModelEndpoints(), other.marketplaceModelEndpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMarketplaceModelEndpointsResponse").add("MarketplaceModelEndpoints", this.hasMarketplaceModelEndpoints() ? this.marketplaceModelEndpoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "marketplaceModelEndpoints": {
                return Optional.ofNullable(clazz.cast(this.marketplaceModelEndpoints()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("marketplaceModelEndpoints", MARKETPLACE_MODEL_ENDPOINTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMarketplaceModelEndpointsResponse, T> g) {
        return obj -> g.apply((ListMarketplaceModelEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private List<MarketplaceModelEndpointSummary> marketplaceModelEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMarketplaceModelEndpointsResponse model) {
            super(model);
            this.marketplaceModelEndpoints(model.marketplaceModelEndpoints);
            this.nextToken(model.nextToken);
        }

        public final List<MarketplaceModelEndpointSummary.Builder> getMarketplaceModelEndpoints() {
            List<MarketplaceModelEndpointSummary.Builder> result = MarketplaceModelEndpointSummariesCopier.copyToBuilder(this.marketplaceModelEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMarketplaceModelEndpoints(Collection<MarketplaceModelEndpointSummary.BuilderImpl> marketplaceModelEndpoints) {
            this.marketplaceModelEndpoints = MarketplaceModelEndpointSummariesCopier.copyFromBuilder(marketplaceModelEndpoints);
        }

        @Override
        public final Builder marketplaceModelEndpoints(Collection<MarketplaceModelEndpointSummary> marketplaceModelEndpoints) {
            this.marketplaceModelEndpoints = MarketplaceModelEndpointSummariesCopier.copy(marketplaceModelEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder marketplaceModelEndpoints(MarketplaceModelEndpointSummary ... marketplaceModelEndpoints) {
            this.marketplaceModelEndpoints(Arrays.asList(marketplaceModelEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder marketplaceModelEndpoints(Consumer<MarketplaceModelEndpointSummary.Builder> ... marketplaceModelEndpoints) {
            this.marketplaceModelEndpoints(Stream.of(marketplaceModelEndpoints).map(c -> (MarketplaceModelEndpointSummary)((MarketplaceModelEndpointSummary.Builder)MarketplaceModelEndpointSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMarketplaceModelEndpointsResponse build() {
            return new ListMarketplaceModelEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMarketplaceModelEndpointsResponse> {
        public Builder marketplaceModelEndpoints(Collection<MarketplaceModelEndpointSummary> var1);

        public Builder marketplaceModelEndpoints(MarketplaceModelEndpointSummary ... var1);

        public Builder marketplaceModelEndpoints(Consumer<MarketplaceModelEndpointSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

