/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig;
import software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfigsCopier;
import software.amazon.awssdk.services.bedrock.model.HumanEvaluationCustomMetric;
import software.amazon.awssdk.services.bedrock.model.HumanEvaluationCustomMetricsCopier;
import software.amazon.awssdk.services.bedrock.model.HumanWorkflowConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HumanEvaluationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HumanEvaluationConfig> {
    private static final SdkField<HumanWorkflowConfig> HUMAN_WORKFLOW_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("humanWorkflowConfig").getter(HumanEvaluationConfig.getter(HumanEvaluationConfig::humanWorkflowConfig)).setter(HumanEvaluationConfig.setter(Builder::humanWorkflowConfig)).constructor(HumanWorkflowConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("humanWorkflowConfig").build()}).build();
    private static final SdkField<List<HumanEvaluationCustomMetric>> CUSTOM_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customMetrics").getter(HumanEvaluationConfig.getter(HumanEvaluationConfig::customMetrics)).setter(HumanEvaluationConfig.setter(Builder::customMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HumanEvaluationCustomMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EvaluationDatasetMetricConfig>> DATASET_METRIC_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("datasetMetricConfigs").getter(HumanEvaluationConfig.getter(HumanEvaluationConfig::datasetMetricConfigs)).setter(HumanEvaluationConfig.setter(Builder::datasetMetricConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetMetricConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationDatasetMetricConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_WORKFLOW_CONFIG_FIELD, CUSTOM_METRICS_FIELD, DATASET_METRIC_CONFIGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("humanWorkflowConfig", HUMAN_WORKFLOW_CONFIG_FIELD);
            this.put("customMetrics", CUSTOM_METRICS_FIELD);
            this.put("datasetMetricConfigs", DATASET_METRIC_CONFIGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final HumanWorkflowConfig humanWorkflowConfig;
    private final List<HumanEvaluationCustomMetric> customMetrics;
    private final List<EvaluationDatasetMetricConfig> datasetMetricConfigs;

    private HumanEvaluationConfig(BuilderImpl builder) {
        this.humanWorkflowConfig = builder.humanWorkflowConfig;
        this.customMetrics = builder.customMetrics;
        this.datasetMetricConfigs = builder.datasetMetricConfigs;
    }

    public final HumanWorkflowConfig humanWorkflowConfig() {
        return this.humanWorkflowConfig;
    }

    public final boolean hasCustomMetrics() {
        return this.customMetrics != null && !(this.customMetrics instanceof SdkAutoConstructList);
    }

    public final List<HumanEvaluationCustomMetric> customMetrics() {
        return this.customMetrics;
    }

    public final boolean hasDatasetMetricConfigs() {
        return this.datasetMetricConfigs != null && !(this.datasetMetricConfigs instanceof SdkAutoConstructList);
    }

    public final List<EvaluationDatasetMetricConfig> datasetMetricConfigs() {
        return this.datasetMetricConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.humanWorkflowConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomMetrics() ? this.customMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetMetricConfigs() ? this.datasetMetricConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanEvaluationConfig)) {
            return false;
        }
        HumanEvaluationConfig other = (HumanEvaluationConfig)obj;
        return Objects.equals(this.humanWorkflowConfig(), other.humanWorkflowConfig()) && this.hasCustomMetrics() == other.hasCustomMetrics() && Objects.equals(this.customMetrics(), other.customMetrics()) && this.hasDatasetMetricConfigs() == other.hasDatasetMetricConfigs() && Objects.equals(this.datasetMetricConfigs(), other.datasetMetricConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"HumanEvaluationConfig").add("HumanWorkflowConfig", (Object)this.humanWorkflowConfig()).add("CustomMetrics", this.hasCustomMetrics() ? this.customMetrics() : null).add("DatasetMetricConfigs", this.hasDatasetMetricConfigs() ? this.datasetMetricConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "humanWorkflowConfig": {
                return Optional.ofNullable(clazz.cast(this.humanWorkflowConfig()));
            }
            case "customMetrics": {
                return Optional.ofNullable(clazz.cast(this.customMetrics()));
            }
            case "datasetMetricConfigs": {
                return Optional.ofNullable(clazz.cast(this.datasetMetricConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HumanEvaluationConfig, T> g) {
        return obj -> g.apply((HumanEvaluationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HumanWorkflowConfig humanWorkflowConfig;
        private List<HumanEvaluationCustomMetric> customMetrics = DefaultSdkAutoConstructList.getInstance();
        private List<EvaluationDatasetMetricConfig> datasetMetricConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HumanEvaluationConfig model) {
            this.humanWorkflowConfig(model.humanWorkflowConfig);
            this.customMetrics(model.customMetrics);
            this.datasetMetricConfigs(model.datasetMetricConfigs);
        }

        public final HumanWorkflowConfig.Builder getHumanWorkflowConfig() {
            return this.humanWorkflowConfig != null ? this.humanWorkflowConfig.toBuilder() : null;
        }

        public final void setHumanWorkflowConfig(HumanWorkflowConfig.BuilderImpl humanWorkflowConfig) {
            this.humanWorkflowConfig = humanWorkflowConfig != null ? humanWorkflowConfig.build() : null;
        }

        @Override
        public final Builder humanWorkflowConfig(HumanWorkflowConfig humanWorkflowConfig) {
            this.humanWorkflowConfig = humanWorkflowConfig;
            return this;
        }

        public final List<HumanEvaluationCustomMetric.Builder> getCustomMetrics() {
            List<HumanEvaluationCustomMetric.Builder> result = HumanEvaluationCustomMetricsCopier.copyToBuilder(this.customMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomMetrics(Collection<HumanEvaluationCustomMetric.BuilderImpl> customMetrics) {
            this.customMetrics = HumanEvaluationCustomMetricsCopier.copyFromBuilder(customMetrics);
        }

        @Override
        public final Builder customMetrics(Collection<HumanEvaluationCustomMetric> customMetrics) {
            this.customMetrics = HumanEvaluationCustomMetricsCopier.copy(customMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customMetrics(HumanEvaluationCustomMetric ... customMetrics) {
            this.customMetrics(Arrays.asList(customMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customMetrics(Consumer<HumanEvaluationCustomMetric.Builder> ... customMetrics) {
            this.customMetrics(Stream.of(customMetrics).map(c -> (HumanEvaluationCustomMetric)((HumanEvaluationCustomMetric.Builder)HumanEvaluationCustomMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EvaluationDatasetMetricConfig.Builder> getDatasetMetricConfigs() {
            List<EvaluationDatasetMetricConfig.Builder> result = EvaluationDatasetMetricConfigsCopier.copyToBuilder(this.datasetMetricConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetMetricConfigs(Collection<EvaluationDatasetMetricConfig.BuilderImpl> datasetMetricConfigs) {
            this.datasetMetricConfigs = EvaluationDatasetMetricConfigsCopier.copyFromBuilder(datasetMetricConfigs);
        }

        @Override
        public final Builder datasetMetricConfigs(Collection<EvaluationDatasetMetricConfig> datasetMetricConfigs) {
            this.datasetMetricConfigs = EvaluationDatasetMetricConfigsCopier.copy(datasetMetricConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetMetricConfigs(EvaluationDatasetMetricConfig ... datasetMetricConfigs) {
            this.datasetMetricConfigs(Arrays.asList(datasetMetricConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetMetricConfigs(Consumer<EvaluationDatasetMetricConfig.Builder> ... datasetMetricConfigs) {
            this.datasetMetricConfigs(Stream.of(datasetMetricConfigs).map(c -> (EvaluationDatasetMetricConfig)((EvaluationDatasetMetricConfig.Builder)EvaluationDatasetMetricConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public HumanEvaluationConfig build() {
            return new HumanEvaluationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HumanEvaluationConfig> {
        public Builder humanWorkflowConfig(HumanWorkflowConfig var1);

        default public Builder humanWorkflowConfig(Consumer<HumanWorkflowConfig.Builder> humanWorkflowConfig) {
            return this.humanWorkflowConfig((HumanWorkflowConfig)((HumanWorkflowConfig.Builder)HumanWorkflowConfig.builder().applyMutation(humanWorkflowConfig)).build());
        }

        public Builder customMetrics(Collection<HumanEvaluationCustomMetric> var1);

        public Builder customMetrics(HumanEvaluationCustomMetric ... var1);

        public Builder customMetrics(Consumer<HumanEvaluationCustomMetric.Builder> ... var1);

        public Builder datasetMetricConfigs(Collection<EvaluationDatasetMetricConfig> var1);

        public Builder datasetMetricConfigs(EvaluationDatasetMetricConfig ... var1);

        public Builder datasetMetricConfigs(Consumer<EvaluationDatasetMetricConfig.Builder> ... var1);
    }
}

