/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TeacherModelConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TeacherModelConfig> {
    private static final SdkField<String> TEACHER_MODEL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("teacherModelIdentifier").getter(TeacherModelConfig.getter(TeacherModelConfig::teacherModelIdentifier)).setter(TeacherModelConfig.setter(Builder::teacherModelIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teacherModelIdentifier").build()}).build();
    private static final SdkField<Integer> MAX_RESPONSE_LENGTH_FOR_INFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResponseLengthForInference").getter(TeacherModelConfig.getter(TeacherModelConfig::maxResponseLengthForInference)).setter(TeacherModelConfig.setter(Builder::maxResponseLengthForInference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResponseLengthForInference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEACHER_MODEL_IDENTIFIER_FIELD, MAX_RESPONSE_LENGTH_FOR_INFERENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("teacherModelIdentifier", TEACHER_MODEL_IDENTIFIER_FIELD);
            this.put("maxResponseLengthForInference", MAX_RESPONSE_LENGTH_FOR_INFERENCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String teacherModelIdentifier;
    private final Integer maxResponseLengthForInference;

    private TeacherModelConfig(BuilderImpl builder) {
        this.teacherModelIdentifier = builder.teacherModelIdentifier;
        this.maxResponseLengthForInference = builder.maxResponseLengthForInference;
    }

    public final String teacherModelIdentifier() {
        return this.teacherModelIdentifier;
    }

    public final Integer maxResponseLengthForInference() {
        return this.maxResponseLengthForInference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.teacherModelIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResponseLengthForInference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeacherModelConfig)) {
            return false;
        }
        TeacherModelConfig other = (TeacherModelConfig)obj;
        return Objects.equals(this.teacherModelIdentifier(), other.teacherModelIdentifier()) && Objects.equals(this.maxResponseLengthForInference(), other.maxResponseLengthForInference());
    }

    public final String toString() {
        return ToString.builder((String)"TeacherModelConfig").add("TeacherModelIdentifier", (Object)this.teacherModelIdentifier()).add("MaxResponseLengthForInference", (Object)this.maxResponseLengthForInference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "teacherModelIdentifier": {
                return Optional.ofNullable(clazz.cast(this.teacherModelIdentifier()));
            }
            case "maxResponseLengthForInference": {
                return Optional.ofNullable(clazz.cast(this.maxResponseLengthForInference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TeacherModelConfig, T> g) {
        return obj -> g.apply((TeacherModelConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String teacherModelIdentifier;
        private Integer maxResponseLengthForInference;

        private BuilderImpl() {
        }

        private BuilderImpl(TeacherModelConfig model) {
            this.teacherModelIdentifier(model.teacherModelIdentifier);
            this.maxResponseLengthForInference(model.maxResponseLengthForInference);
        }

        public final String getTeacherModelIdentifier() {
            return this.teacherModelIdentifier;
        }

        public final void setTeacherModelIdentifier(String teacherModelIdentifier) {
            this.teacherModelIdentifier = teacherModelIdentifier;
        }

        @Override
        public final Builder teacherModelIdentifier(String teacherModelIdentifier) {
            this.teacherModelIdentifier = teacherModelIdentifier;
            return this;
        }

        public final Integer getMaxResponseLengthForInference() {
            return this.maxResponseLengthForInference;
        }

        public final void setMaxResponseLengthForInference(Integer maxResponseLengthForInference) {
            this.maxResponseLengthForInference = maxResponseLengthForInference;
        }

        @Override
        public final Builder maxResponseLengthForInference(Integer maxResponseLengthForInference) {
            this.maxResponseLengthForInference = maxResponseLengthForInference;
            return this;
        }

        public TeacherModelConfig build() {
            return new TeacherModelConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TeacherModelConfig> {
        public Builder teacherModelIdentifier(String var1);

        public Builder maxResponseLengthForInference(Integer var1);
    }
}

