/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.SageMakerEndpoint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointConfig> {
    private static final SdkField<SageMakerEndpoint> SAGE_MAKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sageMaker").getter(EndpointConfig.getter(EndpointConfig::sageMaker)).setter(EndpointConfig.setter(Builder::sageMaker)).constructor(SageMakerEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sageMaker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAGE_MAKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sageMaker", SAGE_MAKER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SageMakerEndpoint sageMaker;
    private final Type type;

    private EndpointConfig(BuilderImpl builder) {
        this.sageMaker = builder.sageMaker;
        this.type = builder.type;
    }

    public final SageMakerEndpoint sageMaker() {
        return this.sageMaker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMaker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointConfig)) {
            return false;
        }
        EndpointConfig other = (EndpointConfig)obj;
        return Objects.equals(this.sageMaker(), other.sageMaker());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointConfig").add("SageMaker", (Object)this.sageMaker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sageMaker": {
                return Optional.ofNullable(clazz.cast(this.sageMaker()));
            }
        }
        return Optional.empty();
    }

    public static EndpointConfig fromSageMaker(SageMakerEndpoint sageMaker) {
        return (EndpointConfig)EndpointConfig.builder().sageMaker(sageMaker).build();
    }

    public static EndpointConfig fromSageMaker(Consumer<SageMakerEndpoint.Builder> sageMaker) {
        SageMakerEndpoint.Builder builder = SageMakerEndpoint.builder();
        sageMaker.accept(builder);
        return EndpointConfig.fromSageMaker((SageMakerEndpoint)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EndpointConfig, T> g) {
        return obj -> g.apply((EndpointConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SAGE_MAKER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SageMakerEndpoint sageMaker;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointConfig model) {
            this.sageMaker(model.sageMaker);
        }

        public final SageMakerEndpoint.Builder getSageMaker() {
            return this.sageMaker != null ? this.sageMaker.toBuilder() : null;
        }

        public final void setSageMaker(SageMakerEndpoint.BuilderImpl sageMaker) {
            SageMakerEndpoint oldValue = this.sageMaker;
            this.sageMaker = sageMaker != null ? sageMaker.build() : null;
            this.handleUnionValueChange(Type.SAGE_MAKER, oldValue, this.sageMaker);
        }

        @Override
        public final Builder sageMaker(SageMakerEndpoint sageMaker) {
            SageMakerEndpoint oldValue = this.sageMaker;
            this.sageMaker = sageMaker;
            this.handleUnionValueChange(Type.SAGE_MAKER, oldValue, this.sageMaker);
            return this;
        }

        public EndpointConfig build() {
            return new EndpointConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointConfig> {
        public Builder sageMaker(SageMakerEndpoint var1);

        default public Builder sageMaker(Consumer<SageMakerEndpoint.Builder> sageMaker) {
            return this.sageMaker((SageMakerEndpoint)((SageMakerEndpoint.Builder)SageMakerEndpoint.builder().applyMutation(sageMaker)).build());
        }
    }
}

