/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.InferenceProfileStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInferenceProfileResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, CreateInferenceProfileResponse> {
    private static final SdkField<String> INFERENCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inferenceProfileArn").getter(CreateInferenceProfileResponse.getter(CreateInferenceProfileResponse::inferenceProfileArn)).setter(CreateInferenceProfileResponse.setter(Builder::inferenceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceProfileArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateInferenceProfileResponse.getter(CreateInferenceProfileResponse::statusAsString)).setter(CreateInferenceProfileResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_PROFILE_ARN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("inferenceProfileArn", INFERENCE_PROFILE_ARN_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private final String inferenceProfileArn;
    private final String status;

    private CreateInferenceProfileResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceProfileArn = builder.inferenceProfileArn;
        this.status = builder.status;
    }

    public final String inferenceProfileArn() {
        return this.inferenceProfileArn;
    }

    public final InferenceProfileStatus status() {
        return InferenceProfileStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInferenceProfileResponse)) {
            return false;
        }
        CreateInferenceProfileResponse other = (CreateInferenceProfileResponse)((Object)obj);
        return Objects.equals(this.inferenceProfileArn(), other.inferenceProfileArn()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInferenceProfileResponse").add("InferenceProfileArn", (Object)this.inferenceProfileArn()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inferenceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.inferenceProfileArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateInferenceProfileResponse, T> g) {
        return obj -> g.apply((CreateInferenceProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String inferenceProfileArn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInferenceProfileResponse model) {
            super(model);
            this.inferenceProfileArn(model.inferenceProfileArn);
            this.status(model.status);
        }

        public final String getInferenceProfileArn() {
            return this.inferenceProfileArn;
        }

        public final void setInferenceProfileArn(String inferenceProfileArn) {
            this.inferenceProfileArn = inferenceProfileArn;
        }

        @Override
        public final Builder inferenceProfileArn(String inferenceProfileArn) {
            this.inferenceProfileArn = inferenceProfileArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateInferenceProfileResponse build() {
            return new CreateInferenceProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInferenceProfileResponse> {
        public Builder inferenceProfileArn(String var1);

        public Builder status(String var1);

        public Builder status(InferenceProfileStatus var1);
    }
}

