/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.CommitmentDuration;
import software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionedModelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisionedModelSummary> {
    private static final SdkField<String> PROVISIONED_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisionedModelName").getter(ProvisionedModelSummary.getter(ProvisionedModelSummary::provisionedModelName)).setter(ProvisionedModelSummary.setter(Builder::provisionedModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedModelName").build()}).build();
    private static final SdkField<String> PROVISIONED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisionedModelArn").getter(ProvisionedModelSummary.getter(ProvisionedModelSummary::provisionedModelArn)).setter(ProvisionedModelSummary.setter(Builder::provisionedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedModelArn").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(ProvisionedModelSummary.getter(ProvisionedModelSummary::modelArn)).setter(ProvisionedModelSummary.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<String> DESIRED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desiredModelArn").getter(ProvisionedModelSummary.getter(ProvisionedModelSummary::desiredModelArn)).setter(ProvisionedModelSummary.setter(Builder::desiredModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredModelArn").build()}).build();
    private static final SdkField<String> FOUNDATION_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("foundationModelArn").getter(ProvisionedModelSummary.getter(ProvisionedModelSummary::foundationModelArn)).setter(ProvisionedModelSummary.setter(Builder::foundationModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("foundationModelArn").build()}).build();
    private static final SdkField<Integer> MODEL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("modelUnits").getter(ProvisionedModelSummary.getter(ProvisionedModelSummary::modelUnits)).setter(ProvisionedModelSummary.setter(Builder::modelUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelUnits").build()}).build();
    private static final SdkField<Integer> DESIRED_MODEL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("desiredModelUnits").getter(ProvisionedModelSummary.getter(ProvisionedModelSummary::desiredModelUnits)).setter(ProvisionedModelSummary.setter(Builder::desiredModelUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredModelUnits").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ProvisionedModelSummary.getter(ProvisionedModelSummary::statusAsString)).setter(ProvisionedModelSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> COMMITMENT_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitmentDuration").getter(ProvisionedModelSummary.getter(ProvisionedModelSummary::commitmentDurationAsString)).setter(ProvisionedModelSummary.setter(Builder::commitmentDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentDuration").build()}).build();
    private static final SdkField<Instant> COMMITMENT_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("commitmentExpirationTime").getter(ProvisionedModelSummary.getter(ProvisionedModelSummary::commitmentExpirationTime)).setter(ProvisionedModelSummary.setter(Builder::commitmentExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentExpirationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ProvisionedModelSummary.getter(ProvisionedModelSummary::creationTime)).setter(ProvisionedModelSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(ProvisionedModelSummary.getter(ProvisionedModelSummary::lastModifiedTime)).setter(ProvisionedModelSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_MODEL_NAME_FIELD, PROVISIONED_MODEL_ARN_FIELD, MODEL_ARN_FIELD, DESIRED_MODEL_ARN_FIELD, FOUNDATION_MODEL_ARN_FIELD, MODEL_UNITS_FIELD, DESIRED_MODEL_UNITS_FIELD, STATUS_FIELD, COMMITMENT_DURATION_FIELD, COMMITMENT_EXPIRATION_TIME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("provisionedModelName", PROVISIONED_MODEL_NAME_FIELD);
            this.put("provisionedModelArn", PROVISIONED_MODEL_ARN_FIELD);
            this.put("modelArn", MODEL_ARN_FIELD);
            this.put("desiredModelArn", DESIRED_MODEL_ARN_FIELD);
            this.put("foundationModelArn", FOUNDATION_MODEL_ARN_FIELD);
            this.put("modelUnits", MODEL_UNITS_FIELD);
            this.put("desiredModelUnits", DESIRED_MODEL_UNITS_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("commitmentDuration", COMMITMENT_DURATION_FIELD);
            this.put("commitmentExpirationTime", COMMITMENT_EXPIRATION_TIME_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String provisionedModelName;
    private final String provisionedModelArn;
    private final String modelArn;
    private final String desiredModelArn;
    private final String foundationModelArn;
    private final Integer modelUnits;
    private final Integer desiredModelUnits;
    private final String status;
    private final String commitmentDuration;
    private final Instant commitmentExpirationTime;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private ProvisionedModelSummary(BuilderImpl builder) {
        this.provisionedModelName = builder.provisionedModelName;
        this.provisionedModelArn = builder.provisionedModelArn;
        this.modelArn = builder.modelArn;
        this.desiredModelArn = builder.desiredModelArn;
        this.foundationModelArn = builder.foundationModelArn;
        this.modelUnits = builder.modelUnits;
        this.desiredModelUnits = builder.desiredModelUnits;
        this.status = builder.status;
        this.commitmentDuration = builder.commitmentDuration;
        this.commitmentExpirationTime = builder.commitmentExpirationTime;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String provisionedModelName() {
        return this.provisionedModelName;
    }

    public final String provisionedModelArn() {
        return this.provisionedModelArn;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String desiredModelArn() {
        return this.desiredModelArn;
    }

    public final String foundationModelArn() {
        return this.foundationModelArn;
    }

    public final Integer modelUnits() {
        return this.modelUnits;
    }

    public final Integer desiredModelUnits() {
        return this.desiredModelUnits;
    }

    public final ProvisionedModelStatus status() {
        return ProvisionedModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final CommitmentDuration commitmentDuration() {
        return CommitmentDuration.fromValue(this.commitmentDuration);
    }

    public final String commitmentDurationAsString() {
        return this.commitmentDuration;
    }

    public final Instant commitmentExpirationTime() {
        return this.commitmentExpirationTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.foundationModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredModelUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitmentDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitmentExpirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedModelSummary)) {
            return false;
        }
        ProvisionedModelSummary other = (ProvisionedModelSummary)obj;
        return Objects.equals(this.provisionedModelName(), other.provisionedModelName()) && Objects.equals(this.provisionedModelArn(), other.provisionedModelArn()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.desiredModelArn(), other.desiredModelArn()) && Objects.equals(this.foundationModelArn(), other.foundationModelArn()) && Objects.equals(this.modelUnits(), other.modelUnits()) && Objects.equals(this.desiredModelUnits(), other.desiredModelUnits()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.commitmentDurationAsString(), other.commitmentDurationAsString()) && Objects.equals(this.commitmentExpirationTime(), other.commitmentExpirationTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionedModelSummary").add("ProvisionedModelName", (Object)this.provisionedModelName()).add("ProvisionedModelArn", (Object)this.provisionedModelArn()).add("ModelArn", (Object)this.modelArn()).add("DesiredModelArn", (Object)this.desiredModelArn()).add("FoundationModelArn", (Object)this.foundationModelArn()).add("ModelUnits", (Object)this.modelUnits()).add("DesiredModelUnits", (Object)this.desiredModelUnits()).add("Status", (Object)this.statusAsString()).add("CommitmentDuration", (Object)this.commitmentDurationAsString()).add("CommitmentExpirationTime", (Object)this.commitmentExpirationTime()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "provisionedModelName": {
                return Optional.ofNullable(clazz.cast(this.provisionedModelName()));
            }
            case "provisionedModelArn": {
                return Optional.ofNullable(clazz.cast(this.provisionedModelArn()));
            }
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "desiredModelArn": {
                return Optional.ofNullable(clazz.cast(this.desiredModelArn()));
            }
            case "foundationModelArn": {
                return Optional.ofNullable(clazz.cast(this.foundationModelArn()));
            }
            case "modelUnits": {
                return Optional.ofNullable(clazz.cast(this.modelUnits()));
            }
            case "desiredModelUnits": {
                return Optional.ofNullable(clazz.cast(this.desiredModelUnits()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "commitmentDuration": {
                return Optional.ofNullable(clazz.cast(this.commitmentDurationAsString()));
            }
            case "commitmentExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.commitmentExpirationTime()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedModelSummary, T> g) {
        return obj -> g.apply((ProvisionedModelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String provisionedModelName;
        private String provisionedModelArn;
        private String modelArn;
        private String desiredModelArn;
        private String foundationModelArn;
        private Integer modelUnits;
        private Integer desiredModelUnits;
        private String status;
        private String commitmentDuration;
        private Instant commitmentExpirationTime;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedModelSummary model) {
            this.provisionedModelName(model.provisionedModelName);
            this.provisionedModelArn(model.provisionedModelArn);
            this.modelArn(model.modelArn);
            this.desiredModelArn(model.desiredModelArn);
            this.foundationModelArn(model.foundationModelArn);
            this.modelUnits(model.modelUnits);
            this.desiredModelUnits(model.desiredModelUnits);
            this.status(model.status);
            this.commitmentDuration(model.commitmentDuration);
            this.commitmentExpirationTime(model.commitmentExpirationTime);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getProvisionedModelName() {
            return this.provisionedModelName;
        }

        public final void setProvisionedModelName(String provisionedModelName) {
            this.provisionedModelName = provisionedModelName;
        }

        @Override
        public final Builder provisionedModelName(String provisionedModelName) {
            this.provisionedModelName = provisionedModelName;
            return this;
        }

        public final String getProvisionedModelArn() {
            return this.provisionedModelArn;
        }

        public final void setProvisionedModelArn(String provisionedModelArn) {
            this.provisionedModelArn = provisionedModelArn;
        }

        @Override
        public final Builder provisionedModelArn(String provisionedModelArn) {
            this.provisionedModelArn = provisionedModelArn;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getDesiredModelArn() {
            return this.desiredModelArn;
        }

        public final void setDesiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
        }

        @Override
        public final Builder desiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
            return this;
        }

        public final String getFoundationModelArn() {
            return this.foundationModelArn;
        }

        public final void setFoundationModelArn(String foundationModelArn) {
            this.foundationModelArn = foundationModelArn;
        }

        @Override
        public final Builder foundationModelArn(String foundationModelArn) {
            this.foundationModelArn = foundationModelArn;
            return this;
        }

        public final Integer getModelUnits() {
            return this.modelUnits;
        }

        public final void setModelUnits(Integer modelUnits) {
            this.modelUnits = modelUnits;
        }

        @Override
        public final Builder modelUnits(Integer modelUnits) {
            this.modelUnits = modelUnits;
            return this;
        }

        public final Integer getDesiredModelUnits() {
            return this.desiredModelUnits;
        }

        public final void setDesiredModelUnits(Integer desiredModelUnits) {
            this.desiredModelUnits = desiredModelUnits;
        }

        @Override
        public final Builder desiredModelUnits(Integer desiredModelUnits) {
            this.desiredModelUnits = desiredModelUnits;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProvisionedModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCommitmentDuration() {
            return this.commitmentDuration;
        }

        public final void setCommitmentDuration(String commitmentDuration) {
            this.commitmentDuration = commitmentDuration;
        }

        @Override
        public final Builder commitmentDuration(String commitmentDuration) {
            this.commitmentDuration = commitmentDuration;
            return this;
        }

        @Override
        public final Builder commitmentDuration(CommitmentDuration commitmentDuration) {
            this.commitmentDuration(commitmentDuration == null ? null : commitmentDuration.toString());
            return this;
        }

        public final Instant getCommitmentExpirationTime() {
            return this.commitmentExpirationTime;
        }

        public final void setCommitmentExpirationTime(Instant commitmentExpirationTime) {
            this.commitmentExpirationTime = commitmentExpirationTime;
        }

        @Override
        public final Builder commitmentExpirationTime(Instant commitmentExpirationTime) {
            this.commitmentExpirationTime = commitmentExpirationTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public ProvisionedModelSummary build() {
            return new ProvisionedModelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisionedModelSummary> {
        public Builder provisionedModelName(String var1);

        public Builder provisionedModelArn(String var1);

        public Builder modelArn(String var1);

        public Builder desiredModelArn(String var1);

        public Builder foundationModelArn(String var1);

        public Builder modelUnits(Integer var1);

        public Builder desiredModelUnits(Integer var1);

        public Builder status(String var1);

        public Builder status(ProvisionedModelStatus var1);

        public Builder commitmentDuration(String var1);

        public Builder commitmentDuration(CommitmentDuration var1);

        public Builder commitmentExpirationTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

