/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data source for the imported model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelDataSource implements SdkPojo, Serializable, ToCopyableBuilder<ModelDataSource.Builder, ModelDataSource> {
    private static final SdkField<S3DataSource> S3_DATA_SOURCE_FIELD = SdkField.<S3DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("s3DataSource").getter(getter(ModelDataSource::s3DataSource)).setter(setter(Builder::s3DataSource))
            .constructor(S3DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DataSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3DataSource s3DataSource;

    private final Type type;

    private ModelDataSource(BuilderImpl builder) {
        this.s3DataSource = builder.s3DataSource;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon S3 data source of the imported model.
     * </p>
     * 
     * @return The Amazon S3 data source of the imported model.
     */
    public final S3DataSource s3DataSource() {
        return s3DataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3DataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDataSource)) {
            return false;
        }
        ModelDataSource other = (ModelDataSource) obj;
        return Objects.equals(s3DataSource(), other.s3DataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelDataSource").add("S3DataSource", s3DataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3DataSource":
            return Optional.ofNullable(clazz.cast(s3DataSource()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3DataSource()} initialized to the given value.
     *
     * <p>
     * The Amazon S3 data source of the imported model.
     * </p>
     * 
     * @param s3DataSource
     *        The Amazon S3 data source of the imported model.
     */
    public static ModelDataSource fromS3DataSource(S3DataSource s3DataSource) {
        return builder().s3DataSource(s3DataSource).build();
    }

    /**
     * Create an instance of this class with {@link #s3DataSource()} initialized to the given value.
     *
     * <p>
     * The Amazon S3 data source of the imported model.
     * </p>
     * 
     * @param s3DataSource
     *        The Amazon S3 data source of the imported model.
     */
    public static ModelDataSource fromS3DataSource(Consumer<S3DataSource.Builder> s3DataSource) {
        S3DataSource.Builder builder = S3DataSource.builder();
        s3DataSource.accept(builder);
        return fromS3DataSource(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelDataSource, T> g) {
        return obj -> g.apply((ModelDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelDataSource> {
        /**
         * <p>
         * The Amazon S3 data source of the imported model.
         * </p>
         * 
         * @param s3DataSource
         *        The Amazon S3 data source of the imported model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataSource(S3DataSource s3DataSource);

        /**
         * <p>
         * The Amazon S3 data source of the imported model.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DataSource.Builder} avoiding the need
         * to create one manually via {@link S3DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #s3DataSource(S3DataSource)}.
         * 
         * @param s3DataSource
         *        a consumer that will call methods on {@link S3DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DataSource(S3DataSource)
         */
        default Builder s3DataSource(Consumer<S3DataSource.Builder> s3DataSource) {
            return s3DataSource(S3DataSource.builder().applyMutation(s3DataSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3DataSource s3DataSource;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDataSource model) {
            s3DataSource(model.s3DataSource);
        }

        public final S3DataSource.Builder getS3DataSource() {
            return s3DataSource != null ? s3DataSource.toBuilder() : null;
        }

        public final void setS3DataSource(S3DataSource.BuilderImpl s3DataSource) {
            Object oldValue = this.s3DataSource;
            this.s3DataSource = s3DataSource != null ? s3DataSource.build() : null;
            handleUnionValueChange(Type.S3_DATA_SOURCE, oldValue, this.s3DataSource);
        }

        @Override
        public final Builder s3DataSource(S3DataSource s3DataSource) {
            Object oldValue = this.s3DataSource;
            this.s3DataSource = s3DataSource;
            handleUnionValueChange(Type.S3_DATA_SOURCE, oldValue, this.s3DataSource);
            return this;
        }

        @Override
        public ModelDataSource build() {
            return new ModelDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ModelDataSource#type()
     */
    public enum Type {
        S3_DATA_SOURCE,

        UNKNOWN_TO_SDK_VERSION
    }
}
