/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to define the models you want used in your model evaluation job. Automated model evaluation jobs support only a
 * single model. In a human-based model evaluation job, your annotator can compare the responses for up to two different
 * models.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationInferenceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationInferenceConfig.Builder, EvaluationInferenceConfig> {
    private static final SdkField<List<EvaluationModelConfig>> MODELS_FIELD = SdkField
            .<List<EvaluationModelConfig>> builder(MarshallingType.LIST)
            .memberName("models")
            .getter(getter(EvaluationInferenceConfig::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationModelConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationModelConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODELS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<EvaluationModelConfig> models;

    private final Type type;

    private EvaluationInferenceConfig(BuilderImpl builder) {
        this.models = builder.models;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Models property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Used to specify the models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModels} method.
     * </p>
     * 
     * @return Used to specify the models.
     */
    public final List<EvaluationModelConfig> models() {
        return models;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasModels() ? models() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationInferenceConfig)) {
            return false;
        }
        EvaluationInferenceConfig other = (EvaluationInferenceConfig) obj;
        return hasModels() == other.hasModels() && Objects.equals(models(), other.models());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationInferenceConfig").add("Models", hasModels() ? models() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "models":
            return Optional.ofNullable(clazz.cast(models()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #models()} initialized to the given value.
     *
     * <p>
     * Used to specify the models.
     * </p>
     * 
     * @param models
     *        Used to specify the models.
     */
    public static EvaluationInferenceConfig fromModels(List<EvaluationModelConfig> models) {
        return builder().models(models).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationInferenceConfig, T> g) {
        return obj -> g.apply((EvaluationInferenceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationInferenceConfig> {
        /**
         * <p>
         * Used to specify the models.
         * </p>
         * 
         * @param models
         *        Used to specify the models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Collection<EvaluationModelConfig> models);

        /**
         * <p>
         * Used to specify the models.
         * </p>
         * 
         * @param models
         *        Used to specify the models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(EvaluationModelConfig... models);

        /**
         * <p>
         * Used to specify the models.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #models(List<EvaluationModelConfig>)}.
         * 
         * @param models
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #models(java.util.Collection<EvaluationModelConfig>)
         */
        Builder models(Consumer<EvaluationModelConfig.Builder>... models);
    }

    static final class BuilderImpl implements Builder {
        private List<EvaluationModelConfig> models = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationInferenceConfig model) {
            models(model.models);
        }

        public final List<EvaluationModelConfig.Builder> getModels() {
            List<EvaluationModelConfig.Builder> result = EvaluationModelConfigsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<EvaluationModelConfig.BuilderImpl> models) {
            Object oldValue = this.models;
            this.models = EvaluationModelConfigsCopier.copyFromBuilder(models);
            handleUnionValueChange(Type.MODELS, oldValue, this.models);
        }

        @Override
        public final Builder models(Collection<EvaluationModelConfig> models) {
            Object oldValue = this.models;
            this.models = EvaluationModelConfigsCopier.copy(models);
            handleUnionValueChange(Type.MODELS, oldValue, this.models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(EvaluationModelConfig... models) {
            models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<EvaluationModelConfig.Builder>... models) {
            models(Stream.of(models).map(c -> EvaluationModelConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EvaluationInferenceConfig build() {
            return new EvaluationInferenceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EvaluationInferenceConfig#type()
     */
    public enum Type {
        MODELS,

        UNKNOWN_TO_SDK_VERSION
    }
}
