/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelInvocationJobRequest extends BedrockRequest implements
        ToCopyableBuilder<CreateModelInvocationJobRequest.Builder, CreateModelInvocationJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(CreateModelInvocationJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateModelInvocationJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateModelInvocationJobRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(CreateModelInvocationJobRequest::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<ModelInvocationJobInputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<ModelInvocationJobInputDataConfig> builder(MarshallingType.SDK_POJO).memberName("inputDataConfig")
            .getter(getter(CreateModelInvocationJobRequest::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(ModelInvocationJobInputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDataConfig").build()).build();

    private static final SdkField<ModelInvocationJobOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<ModelInvocationJobOutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("outputDataConfig")
            .getter(getter(CreateModelInvocationJobRequest::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(ModelInvocationJobOutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()).build();

    private static final SdkField<Integer> TIMEOUT_DURATION_IN_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutDurationInHours").getter(getter(CreateModelInvocationJobRequest::timeoutDurationInHours))
            .setter(setter(Builder::timeoutDurationInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutDurationInHours").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateModelInvocationJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            ROLE_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, MODEL_ID_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD,
            TIMEOUT_DURATION_IN_HOURS_FIELD, TAGS_FIELD));

    private final String jobName;

    private final String roleArn;

    private final String clientRequestToken;

    private final String modelId;

    private final ModelInvocationJobInputDataConfig inputDataConfig;

    private final ModelInvocationJobOutputDataConfig outputDataConfig;

    private final Integer timeoutDurationInHours;

    private final List<Tag> tags;

    private CreateModelInvocationJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.roleArn = builder.roleArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.modelId = builder.modelId;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.timeoutDurationInHours = builder.timeoutDurationInHours;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name to give the batch inference job.
     * </p>
     * 
     * @return A name to give the batch inference job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch inference. You
     * can use the console to create a default service role or follow the steps at <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html">Create a service role for batch
     * inference</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch
     *         inference. You can use the console to create a default service role or follow the steps at <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html">Create a service role for
     *         batch inference</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The unique identifier of the foundation model to use for the batch inference job.
     * </p>
     * 
     * @return The unique identifier of the foundation model to use for the batch inference job.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * Details about the location of the input to the batch inference job.
     * </p>
     * 
     * @return Details about the location of the input to the batch inference job.
     */
    public final ModelInvocationJobInputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * Details about the location of the output of the batch inference job.
     * </p>
     * 
     * @return Details about the location of the output of the batch inference job.
     */
    public final ModelInvocationJobOutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The number of hours after which to force the batch inference job to time out.
     * </p>
     * 
     * @return The number of hours after which to force the batch inference job to time out.
     */
    public final Integer timeoutDurationInHours() {
        return timeoutDurationInHours;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags to associate with the batch inference job. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging Amazon Bedrock resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags to associate with the batch inference job. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging Amazon Bedrock
     *         resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelInvocationJobRequest)) {
            return false;
        }
        CreateModelInvocationJobRequest other = (CreateModelInvocationJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(modelId(), other.modelId())
                && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(timeoutDurationInHours(), other.timeoutDurationInHours()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelInvocationJobRequest").add("JobName", jobName()).add("RoleArn", roleArn())
                .add("ClientRequestToken", clientRequestToken()).add("ModelId", modelId())
                .add("InputDataConfig", inputDataConfig()).add("OutputDataConfig", outputDataConfig())
                .add("TimeoutDurationInHours", timeoutDurationInHours()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "inputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "outputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "timeoutDurationInHours":
            return Optional.ofNullable(clazz.cast(timeoutDurationInHours()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelInvocationJobRequest, T> g) {
        return obj -> g.apply((CreateModelInvocationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateModelInvocationJobRequest> {
        /**
         * <p>
         * A name to give the batch inference job.
         * </p>
         * 
         * @param jobName
         *        A name to give the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch inference.
         * You can use the console to create a default service role or follow the steps at <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html">Create a service role for batch
         * inference</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch
         *        inference. You can use the console to create a default service role or follow the steps at <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html">Create a service role
         *        for batch inference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The unique identifier of the foundation model to use for the batch inference job.
         * </p>
         * 
         * @param modelId
         *        The unique identifier of the foundation model to use for the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * Details about the location of the input to the batch inference job.
         * </p>
         * 
         * @param inputDataConfig
         *        Details about the location of the input to the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(ModelInvocationJobInputDataConfig inputDataConfig);

        /**
         * <p>
         * Details about the location of the input to the batch inference job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ModelInvocationJobInputDataConfig.Builder} avoiding the need to create one manually via
         * {@link ModelInvocationJobInputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelInvocationJobInputDataConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDataConfig(ModelInvocationJobInputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link ModelInvocationJobInputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(ModelInvocationJobInputDataConfig)
         */
        default Builder inputDataConfig(Consumer<ModelInvocationJobInputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(ModelInvocationJobInputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * Details about the location of the output of the batch inference job.
         * </p>
         * 
         * @param outputDataConfig
         *        Details about the location of the output of the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(ModelInvocationJobOutputDataConfig outputDataConfig);

        /**
         * <p>
         * Details about the location of the output of the batch inference job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ModelInvocationJobOutputDataConfig.Builder} avoiding the need to create one manually via
         * {@link ModelInvocationJobOutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelInvocationJobOutputDataConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputDataConfig(ModelInvocationJobOutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link ModelInvocationJobOutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(ModelInvocationJobOutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<ModelInvocationJobOutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(ModelInvocationJobOutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The number of hours after which to force the batch inference job to time out.
         * </p>
         * 
         * @param timeoutDurationInHours
         *        The number of hours after which to force the batch inference job to time out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutDurationInHours(Integer timeoutDurationInHours);

        /**
         * <p>
         * Any tags to associate with the batch inference job. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging Amazon Bedrock
         * resources</a>.
         * </p>
         * 
         * @param tags
         *        Any tags to associate with the batch inference job. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging Amazon Bedrock
         *        resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags to associate with the batch inference job. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging Amazon Bedrock
         * resources</a>.
         * </p>
         * 
         * @param tags
         *        Any tags to associate with the batch inference job. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging Amazon Bedrock
         *        resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags to associate with the batch inference job. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging Amazon Bedrock
         * resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.bedrock.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String jobName;

        private String roleArn;

        private String clientRequestToken;

        private String modelId;

        private ModelInvocationJobInputDataConfig inputDataConfig;

        private ModelInvocationJobOutputDataConfig outputDataConfig;

        private Integer timeoutDurationInHours;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelInvocationJobRequest model) {
            super(model);
            jobName(model.jobName);
            roleArn(model.roleArn);
            clientRequestToken(model.clientRequestToken);
            modelId(model.modelId);
            inputDataConfig(model.inputDataConfig);
            outputDataConfig(model.outputDataConfig);
            timeoutDurationInHours(model.timeoutDurationInHours);
            tags(model.tags);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final ModelInvocationJobInputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(ModelInvocationJobInputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(ModelInvocationJobInputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final ModelInvocationJobOutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(ModelInvocationJobOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(ModelInvocationJobOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final Integer getTimeoutDurationInHours() {
            return timeoutDurationInHours;
        }

        public final void setTimeoutDurationInHours(Integer timeoutDurationInHours) {
            this.timeoutDurationInHours = timeoutDurationInHours;
        }

        @Override
        public final Builder timeoutDurationInHours(Integer timeoutDurationInHours) {
            this.timeoutDurationInHours = timeoutDurationInHours;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelInvocationJobRequest build() {
            return new CreateModelInvocationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
