/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.ModelInvocationJobInputDataConfig;
import software.amazon.awssdk.services.bedrock.model.ModelInvocationJobOutputDataConfig;
import software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetModelInvocationJobResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, GetModelInvocationJobResponse> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::jobArn)).setter(GetModelInvocationJobResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::jobName)).setter(GetModelInvocationJobResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::modelId)).setter(GetModelInvocationJobResponse.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::clientRequestToken)).setter(GetModelInvocationJobResponse.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::roleArn)).setter(GetModelInvocationJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::statusAsString)).setter(GetModelInvocationJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::message)).setter(GetModelInvocationJobResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("submitTime").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::submitTime)).setter(GetModelInvocationJobResponse.setter(Builder::submitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submitTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::lastModifiedTime)).setter(GetModelInvocationJobResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::endTime)).setter(GetModelInvocationJobResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ModelInvocationJobInputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputDataConfig").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::inputDataConfig)).setter(GetModelInvocationJobResponse.setter(Builder::inputDataConfig)).constructor(ModelInvocationJobInputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDataConfig").build()}).build();
    private static final SdkField<ModelInvocationJobOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputDataConfig").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::outputDataConfig)).setter(GetModelInvocationJobResponse.setter(Builder::outputDataConfig)).constructor(ModelInvocationJobOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()}).build();
    private static final SdkField<Integer> TIMEOUT_DURATION_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutDurationInHours").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::timeoutDurationInHours)).setter(GetModelInvocationJobResponse.setter(Builder::timeoutDurationInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutDurationInHours").build()}).build();
    private static final SdkField<Instant> JOB_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("jobExpirationTime").getter(GetModelInvocationJobResponse.getter(GetModelInvocationJobResponse::jobExpirationTime)).setter(GetModelInvocationJobResponse.setter(Builder::jobExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExpirationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_NAME_FIELD, MODEL_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, MESSAGE_FIELD, SUBMIT_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, END_TIME_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, TIMEOUT_DURATION_IN_HOURS_FIELD, JOB_EXPIRATION_TIME_FIELD));
    private final String jobArn;
    private final String jobName;
    private final String modelId;
    private final String clientRequestToken;
    private final String roleArn;
    private final String status;
    private final String message;
    private final Instant submitTime;
    private final Instant lastModifiedTime;
    private final Instant endTime;
    private final ModelInvocationJobInputDataConfig inputDataConfig;
    private final ModelInvocationJobOutputDataConfig outputDataConfig;
    private final Integer timeoutDurationInHours;
    private final Instant jobExpirationTime;

    private GetModelInvocationJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.modelId = builder.modelId;
        this.clientRequestToken = builder.clientRequestToken;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.message = builder.message;
        this.submitTime = builder.submitTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.endTime = builder.endTime;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.timeoutDurationInHours = builder.timeoutDurationInHours;
        this.jobExpirationTime = builder.jobExpirationTime;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ModelInvocationJobStatus status() {
        return ModelInvocationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final Instant submitTime() {
        return this.submitTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final ModelInvocationJobInputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public final ModelInvocationJobOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final Integer timeoutDurationInHours() {
        return this.timeoutDurationInHours;
    }

    public final Instant jobExpirationTime() {
        return this.jobExpirationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExpirationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelInvocationJobResponse)) {
            return false;
        }
        GetModelInvocationJobResponse other = (GetModelInvocationJobResponse)((Object)obj);
        return Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.submitTime(), other.submitTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.timeoutDurationInHours(), other.timeoutDurationInHours()) && Objects.equals(this.jobExpirationTime(), other.jobExpirationTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetModelInvocationJobResponse").add("JobArn", (Object)this.jobArn()).add("JobName", (Object)this.jobName()).add("ModelId", (Object)this.modelId()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("Message", (Object)(this.message() == null ? null : "*** Sensitive Data Redacted ***")).add("SubmitTime", (Object)this.submitTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("EndTime", (Object)this.endTime()).add("InputDataConfig", (Object)this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("TimeoutDurationInHours", (Object)this.timeoutDurationInHours()).add("JobExpirationTime", (Object)this.jobExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "submitTime": {
                return Optional.ofNullable(clazz.cast(this.submitTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "inputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "outputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "timeoutDurationInHours": {
                return Optional.ofNullable(clazz.cast(this.timeoutDurationInHours()));
            }
            case "jobExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.jobExpirationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetModelInvocationJobResponse, T> g) {
        return obj -> g.apply((GetModelInvocationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String jobArn;
        private String jobName;
        private String modelId;
        private String clientRequestToken;
        private String roleArn;
        private String status;
        private String message;
        private Instant submitTime;
        private Instant lastModifiedTime;
        private Instant endTime;
        private ModelInvocationJobInputDataConfig inputDataConfig;
        private ModelInvocationJobOutputDataConfig outputDataConfig;
        private Integer timeoutDurationInHours;
        private Instant jobExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelInvocationJobResponse model) {
            super(model);
            this.jobArn(model.jobArn);
            this.jobName(model.jobName);
            this.modelId(model.modelId);
            this.clientRequestToken(model.clientRequestToken);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.message(model.message);
            this.submitTime(model.submitTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.endTime(model.endTime);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.timeoutDurationInHours(model.timeoutDurationInHours);
            this.jobExpirationTime(model.jobExpirationTime);
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelInvocationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getSubmitTime() {
            return this.submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final ModelInvocationJobInputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(ModelInvocationJobInputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(ModelInvocationJobInputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final ModelInvocationJobOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(ModelInvocationJobOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(ModelInvocationJobOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final Integer getTimeoutDurationInHours() {
            return this.timeoutDurationInHours;
        }

        public final void setTimeoutDurationInHours(Integer timeoutDurationInHours) {
            this.timeoutDurationInHours = timeoutDurationInHours;
        }

        @Override
        public final Builder timeoutDurationInHours(Integer timeoutDurationInHours) {
            this.timeoutDurationInHours = timeoutDurationInHours;
            return this;
        }

        public final Instant getJobExpirationTime() {
            return this.jobExpirationTime;
        }

        public final void setJobExpirationTime(Instant jobExpirationTime) {
            this.jobExpirationTime = jobExpirationTime;
        }

        @Override
        public final Builder jobExpirationTime(Instant jobExpirationTime) {
            this.jobExpirationTime = jobExpirationTime;
            return this;
        }

        @Override
        public GetModelInvocationJobResponse build() {
            return new GetModelInvocationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetModelInvocationJobResponse> {
        public Builder jobArn(String var1);

        public Builder jobName(String var1);

        public Builder modelId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(ModelInvocationJobStatus var1);

        public Builder message(String var1);

        public Builder submitTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder inputDataConfig(ModelInvocationJobInputDataConfig var1);

        default public Builder inputDataConfig(Consumer<ModelInvocationJobInputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((ModelInvocationJobInputDataConfig)((ModelInvocationJobInputDataConfig.Builder)ModelInvocationJobInputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder outputDataConfig(ModelInvocationJobOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<ModelInvocationJobOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((ModelInvocationJobOutputDataConfig)((ModelInvocationJobOutputDataConfig.Builder)ModelInvocationJobOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder timeoutDurationInHours(Integer var1);

        public Builder jobExpirationTime(Instant var1);
    }
}

