/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProvisionedModelThroughputRequest extends BedrockRequest implements
        ToCopyableBuilder<CreateProvisionedModelThroughputRequest.Builder, CreateProvisionedModelThroughputRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateProvisionedModelThroughputRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Integer> MODEL_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("modelUnits").getter(getter(CreateProvisionedModelThroughputRequest::modelUnits))
            .setter(setter(Builder::modelUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelUnits").build()).build();

    private static final SdkField<String> PROVISIONED_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provisionedModelName").getter(getter(CreateProvisionedModelThroughputRequest::provisionedModelName))
            .setter(setter(Builder::provisionedModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedModelName").build())
            .build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(CreateProvisionedModelThroughputRequest::modelId))
            .setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> COMMITMENT_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitmentDuration").getter(getter(CreateProvisionedModelThroughputRequest::commitmentDurationAsString))
            .setter(setter(Builder::commitmentDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentDuration").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateProvisionedModelThroughputRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            MODEL_UNITS_FIELD, PROVISIONED_MODEL_NAME_FIELD, MODEL_ID_FIELD, COMMITMENT_DURATION_FIELD, TAGS_FIELD));

    private final String clientRequestToken;

    private final Integer modelUnits;

    private final String provisionedModelName;

    private final String modelId;

    private final String commitmentDuration;

    private final List<Tag> tags;

    private CreateProvisionedModelThroughputRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.modelUnits = builder.modelUnits;
        this.provisionedModelName = builder.provisionedModelName;
        this.modelId = builder.modelId;
        this.commitmentDuration = builder.commitmentDuration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Unique token value that you can provide. If this token matches a previous request, Amazon Bedrock ignores the
     * request, but does not return an error.
     * </p>
     * 
     * @return Unique token value that you can provide. If this token matches a previous request, Amazon Bedrock ignores
     *         the request, but does not return an error.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Number of model units to allocate.
     * </p>
     * 
     * @return Number of model units to allocate.
     */
    public final Integer modelUnits() {
        return modelUnits;
    }

    /**
     * <p>
     * Unique name for this provisioned throughput.
     * </p>
     * 
     * @return Unique name for this provisioned throughput.
     */
    public final String provisionedModelName() {
        return provisionedModelName;
    }

    /**
     * <p>
     * Name or ARN of the model to associate with this provisioned throughput.
     * </p>
     * 
     * @return Name or ARN of the model to associate with this provisioned throughput.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * Commitment duration requested for the provisioned throughput.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #commitmentDuration} will return {@link CommitmentDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #commitmentDurationAsString}.
     * </p>
     * 
     * @return Commitment duration requested for the provisioned throughput.
     * @see CommitmentDuration
     */
    public final CommitmentDuration commitmentDuration() {
        return CommitmentDuration.fromValue(commitmentDuration);
    }

    /**
     * <p>
     * Commitment duration requested for the provisioned throughput.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #commitmentDuration} will return {@link CommitmentDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #commitmentDurationAsString}.
     * </p>
     * 
     * @return Commitment duration requested for the provisioned throughput.
     * @see CommitmentDuration
     */
    public final String commitmentDurationAsString() {
        return commitmentDuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to associate with this provisioned throughput.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to associate with this provisioned throughput.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(modelUnits());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedModelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(commitmentDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisionedModelThroughputRequest)) {
            return false;
        }
        CreateProvisionedModelThroughputRequest other = (CreateProvisionedModelThroughputRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(modelUnits(), other.modelUnits())
                && Objects.equals(provisionedModelName(), other.provisionedModelName())
                && Objects.equals(modelId(), other.modelId())
                && Objects.equals(commitmentDurationAsString(), other.commitmentDurationAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProvisionedModelThroughputRequest").add("ClientRequestToken", clientRequestToken())
                .add("ModelUnits", modelUnits()).add("ProvisionedModelName", provisionedModelName()).add("ModelId", modelId())
                .add("CommitmentDuration", commitmentDurationAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "modelUnits":
            return Optional.ofNullable(clazz.cast(modelUnits()));
        case "provisionedModelName":
            return Optional.ofNullable(clazz.cast(provisionedModelName()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "commitmentDuration":
            return Optional.ofNullable(clazz.cast(commitmentDurationAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisionedModelThroughputRequest, T> g) {
        return obj -> g.apply((CreateProvisionedModelThroughputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateProvisionedModelThroughputRequest> {
        /**
         * <p>
         * Unique token value that you can provide. If this token matches a previous request, Amazon Bedrock ignores the
         * request, but does not return an error.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique token value that you can provide. If this token matches a previous request, Amazon Bedrock
         *        ignores the request, but does not return an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Number of model units to allocate.
         * </p>
         * 
         * @param modelUnits
         *        Number of model units to allocate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelUnits(Integer modelUnits);

        /**
         * <p>
         * Unique name for this provisioned throughput.
         * </p>
         * 
         * @param provisionedModelName
         *        Unique name for this provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedModelName(String provisionedModelName);

        /**
         * <p>
         * Name or ARN of the model to associate with this provisioned throughput.
         * </p>
         * 
         * @param modelId
         *        Name or ARN of the model to associate with this provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * Commitment duration requested for the provisioned throughput.
         * </p>
         * 
         * @param commitmentDuration
         *        Commitment duration requested for the provisioned throughput.
         * @see CommitmentDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommitmentDuration
         */
        Builder commitmentDuration(String commitmentDuration);

        /**
         * <p>
         * Commitment duration requested for the provisioned throughput.
         * </p>
         * 
         * @param commitmentDuration
         *        Commitment duration requested for the provisioned throughput.
         * @see CommitmentDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommitmentDuration
         */
        Builder commitmentDuration(CommitmentDuration commitmentDuration);

        /**
         * <p>
         * Tags to associate with this provisioned throughput.
         * </p>
         * 
         * @param tags
         *        Tags to associate with this provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to associate with this provisioned throughput.
         * </p>
         * 
         * @param tags
         *        Tags to associate with this provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to associate with this provisioned throughput.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.bedrock.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private Integer modelUnits;

        private String provisionedModelName;

        private String modelId;

        private String commitmentDuration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisionedModelThroughputRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            modelUnits(model.modelUnits);
            provisionedModelName(model.provisionedModelName);
            modelId(model.modelId);
            commitmentDuration(model.commitmentDuration);
            tags(model.tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Integer getModelUnits() {
            return modelUnits;
        }

        public final void setModelUnits(Integer modelUnits) {
            this.modelUnits = modelUnits;
        }

        @Override
        public final Builder modelUnits(Integer modelUnits) {
            this.modelUnits = modelUnits;
            return this;
        }

        public final String getProvisionedModelName() {
            return provisionedModelName;
        }

        public final void setProvisionedModelName(String provisionedModelName) {
            this.provisionedModelName = provisionedModelName;
        }

        @Override
        public final Builder provisionedModelName(String provisionedModelName) {
            this.provisionedModelName = provisionedModelName;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getCommitmentDuration() {
            return commitmentDuration;
        }

        public final void setCommitmentDuration(String commitmentDuration) {
            this.commitmentDuration = commitmentDuration;
        }

        @Override
        public final Builder commitmentDuration(String commitmentDuration) {
            this.commitmentDuration = commitmentDuration;
            return this;
        }

        @Override
        public final Builder commitmentDuration(CommitmentDuration commitmentDuration) {
            this.commitmentDuration(commitmentDuration == null ? null : commitmentDuration.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProvisionedModelThroughputRequest build() {
            return new CreateProvisionedModelThroughputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
