/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.CommitmentDuration;
import software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProvisionedModelThroughputResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, GetProvisionedModelThroughputResponse> {
    private static final SdkField<Integer> MODEL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("modelUnits").getter(GetProvisionedModelThroughputResponse.getter(GetProvisionedModelThroughputResponse::modelUnits)).setter(GetProvisionedModelThroughputResponse.setter(Builder::modelUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelUnits").build()}).build();
    private static final SdkField<Integer> DESIRED_MODEL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("desiredModelUnits").getter(GetProvisionedModelThroughputResponse.getter(GetProvisionedModelThroughputResponse::desiredModelUnits)).setter(GetProvisionedModelThroughputResponse.setter(Builder::desiredModelUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredModelUnits").build()}).build();
    private static final SdkField<String> PROVISIONED_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisionedModelName").getter(GetProvisionedModelThroughputResponse.getter(GetProvisionedModelThroughputResponse::provisionedModelName)).setter(GetProvisionedModelThroughputResponse.setter(Builder::provisionedModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedModelName").build()}).build();
    private static final SdkField<String> PROVISIONED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisionedModelArn").getter(GetProvisionedModelThroughputResponse.getter(GetProvisionedModelThroughputResponse::provisionedModelArn)).setter(GetProvisionedModelThroughputResponse.setter(Builder::provisionedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedModelArn").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(GetProvisionedModelThroughputResponse.getter(GetProvisionedModelThroughputResponse::modelArn)).setter(GetProvisionedModelThroughputResponse.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<String> DESIRED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desiredModelArn").getter(GetProvisionedModelThroughputResponse.getter(GetProvisionedModelThroughputResponse::desiredModelArn)).setter(GetProvisionedModelThroughputResponse.setter(Builder::desiredModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredModelArn").build()}).build();
    private static final SdkField<String> FOUNDATION_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("foundationModelArn").getter(GetProvisionedModelThroughputResponse.getter(GetProvisionedModelThroughputResponse::foundationModelArn)).setter(GetProvisionedModelThroughputResponse.setter(Builder::foundationModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("foundationModelArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetProvisionedModelThroughputResponse.getter(GetProvisionedModelThroughputResponse::statusAsString)).setter(GetProvisionedModelThroughputResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetProvisionedModelThroughputResponse.getter(GetProvisionedModelThroughputResponse::creationTime)).setter(GetProvisionedModelThroughputResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(GetProvisionedModelThroughputResponse.getter(GetProvisionedModelThroughputResponse::lastModifiedTime)).setter(GetProvisionedModelThroughputResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(GetProvisionedModelThroughputResponse.getter(GetProvisionedModelThroughputResponse::failureMessage)).setter(GetProvisionedModelThroughputResponse.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final SdkField<String> COMMITMENT_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitmentDuration").getter(GetProvisionedModelThroughputResponse.getter(GetProvisionedModelThroughputResponse::commitmentDurationAsString)).setter(GetProvisionedModelThroughputResponse.setter(Builder::commitmentDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentDuration").build()}).build();
    private static final SdkField<Instant> COMMITMENT_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("commitmentExpirationTime").getter(GetProvisionedModelThroughputResponse.getter(GetProvisionedModelThroughputResponse::commitmentExpirationTime)).setter(GetProvisionedModelThroughputResponse.setter(Builder::commitmentExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentExpirationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_UNITS_FIELD, DESIRED_MODEL_UNITS_FIELD, PROVISIONED_MODEL_NAME_FIELD, PROVISIONED_MODEL_ARN_FIELD, MODEL_ARN_FIELD, DESIRED_MODEL_ARN_FIELD, FOUNDATION_MODEL_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_MESSAGE_FIELD, COMMITMENT_DURATION_FIELD, COMMITMENT_EXPIRATION_TIME_FIELD));
    private final Integer modelUnits;
    private final Integer desiredModelUnits;
    private final String provisionedModelName;
    private final String provisionedModelArn;
    private final String modelArn;
    private final String desiredModelArn;
    private final String foundationModelArn;
    private final String status;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String failureMessage;
    private final String commitmentDuration;
    private final Instant commitmentExpirationTime;

    private GetProvisionedModelThroughputResponse(BuilderImpl builder) {
        super(builder);
        this.modelUnits = builder.modelUnits;
        this.desiredModelUnits = builder.desiredModelUnits;
        this.provisionedModelName = builder.provisionedModelName;
        this.provisionedModelArn = builder.provisionedModelArn;
        this.modelArn = builder.modelArn;
        this.desiredModelArn = builder.desiredModelArn;
        this.foundationModelArn = builder.foundationModelArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureMessage = builder.failureMessage;
        this.commitmentDuration = builder.commitmentDuration;
        this.commitmentExpirationTime = builder.commitmentExpirationTime;
    }

    public final Integer modelUnits() {
        return this.modelUnits;
    }

    public final Integer desiredModelUnits() {
        return this.desiredModelUnits;
    }

    public final String provisionedModelName() {
        return this.provisionedModelName;
    }

    public final String provisionedModelArn() {
        return this.provisionedModelArn;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String desiredModelArn() {
        return this.desiredModelArn;
    }

    public final String foundationModelArn() {
        return this.foundationModelArn;
    }

    public final ProvisionedModelStatus status() {
        return ProvisionedModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final CommitmentDuration commitmentDuration() {
        return CommitmentDuration.fromValue(this.commitmentDuration);
    }

    public final String commitmentDurationAsString() {
        return this.commitmentDuration;
    }

    public final Instant commitmentExpirationTime() {
        return this.commitmentExpirationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredModelUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.foundationModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitmentDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitmentExpirationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProvisionedModelThroughputResponse)) {
            return false;
        }
        GetProvisionedModelThroughputResponse other = (GetProvisionedModelThroughputResponse)((Object)obj);
        return Objects.equals(this.modelUnits(), other.modelUnits()) && Objects.equals(this.desiredModelUnits(), other.desiredModelUnits()) && Objects.equals(this.provisionedModelName(), other.provisionedModelName()) && Objects.equals(this.provisionedModelArn(), other.provisionedModelArn()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.desiredModelArn(), other.desiredModelArn()) && Objects.equals(this.foundationModelArn(), other.foundationModelArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.commitmentDurationAsString(), other.commitmentDurationAsString()) && Objects.equals(this.commitmentExpirationTime(), other.commitmentExpirationTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetProvisionedModelThroughputResponse").add("ModelUnits", (Object)this.modelUnits()).add("DesiredModelUnits", (Object)this.desiredModelUnits()).add("ProvisionedModelName", (Object)this.provisionedModelName()).add("ProvisionedModelArn", (Object)this.provisionedModelArn()).add("ModelArn", (Object)this.modelArn()).add("DesiredModelArn", (Object)this.desiredModelArn()).add("FoundationModelArn", (Object)this.foundationModelArn()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureMessage", (Object)this.failureMessage()).add("CommitmentDuration", (Object)this.commitmentDurationAsString()).add("CommitmentExpirationTime", (Object)this.commitmentExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelUnits": {
                return Optional.ofNullable(clazz.cast(this.modelUnits()));
            }
            case "desiredModelUnits": {
                return Optional.ofNullable(clazz.cast(this.desiredModelUnits()));
            }
            case "provisionedModelName": {
                return Optional.ofNullable(clazz.cast(this.provisionedModelName()));
            }
            case "provisionedModelArn": {
                return Optional.ofNullable(clazz.cast(this.provisionedModelArn()));
            }
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "desiredModelArn": {
                return Optional.ofNullable(clazz.cast(this.desiredModelArn()));
            }
            case "foundationModelArn": {
                return Optional.ofNullable(clazz.cast(this.foundationModelArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "commitmentDuration": {
                return Optional.ofNullable(clazz.cast(this.commitmentDurationAsString()));
            }
            case "commitmentExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.commitmentExpirationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProvisionedModelThroughputResponse, T> g) {
        return obj -> g.apply((GetProvisionedModelThroughputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private Integer modelUnits;
        private Integer desiredModelUnits;
        private String provisionedModelName;
        private String provisionedModelArn;
        private String modelArn;
        private String desiredModelArn;
        private String foundationModelArn;
        private String status;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String failureMessage;
        private String commitmentDuration;
        private Instant commitmentExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProvisionedModelThroughputResponse model) {
            super(model);
            this.modelUnits(model.modelUnits);
            this.desiredModelUnits(model.desiredModelUnits);
            this.provisionedModelName(model.provisionedModelName);
            this.provisionedModelArn(model.provisionedModelArn);
            this.modelArn(model.modelArn);
            this.desiredModelArn(model.desiredModelArn);
            this.foundationModelArn(model.foundationModelArn);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureMessage(model.failureMessage);
            this.commitmentDuration(model.commitmentDuration);
            this.commitmentExpirationTime(model.commitmentExpirationTime);
        }

        public final Integer getModelUnits() {
            return this.modelUnits;
        }

        public final void setModelUnits(Integer modelUnits) {
            this.modelUnits = modelUnits;
        }

        @Override
        public final Builder modelUnits(Integer modelUnits) {
            this.modelUnits = modelUnits;
            return this;
        }

        public final Integer getDesiredModelUnits() {
            return this.desiredModelUnits;
        }

        public final void setDesiredModelUnits(Integer desiredModelUnits) {
            this.desiredModelUnits = desiredModelUnits;
        }

        @Override
        public final Builder desiredModelUnits(Integer desiredModelUnits) {
            this.desiredModelUnits = desiredModelUnits;
            return this;
        }

        public final String getProvisionedModelName() {
            return this.provisionedModelName;
        }

        public final void setProvisionedModelName(String provisionedModelName) {
            this.provisionedModelName = provisionedModelName;
        }

        @Override
        public final Builder provisionedModelName(String provisionedModelName) {
            this.provisionedModelName = provisionedModelName;
            return this;
        }

        public final String getProvisionedModelArn() {
            return this.provisionedModelArn;
        }

        public final void setProvisionedModelArn(String provisionedModelArn) {
            this.provisionedModelArn = provisionedModelArn;
        }

        @Override
        public final Builder provisionedModelArn(String provisionedModelArn) {
            this.provisionedModelArn = provisionedModelArn;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getDesiredModelArn() {
            return this.desiredModelArn;
        }

        public final void setDesiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
        }

        @Override
        public final Builder desiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
            return this;
        }

        public final String getFoundationModelArn() {
            return this.foundationModelArn;
        }

        public final void setFoundationModelArn(String foundationModelArn) {
            this.foundationModelArn = foundationModelArn;
        }

        @Override
        public final Builder foundationModelArn(String foundationModelArn) {
            this.foundationModelArn = foundationModelArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProvisionedModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getCommitmentDuration() {
            return this.commitmentDuration;
        }

        public final void setCommitmentDuration(String commitmentDuration) {
            this.commitmentDuration = commitmentDuration;
        }

        @Override
        public final Builder commitmentDuration(String commitmentDuration) {
            this.commitmentDuration = commitmentDuration;
            return this;
        }

        @Override
        public final Builder commitmentDuration(CommitmentDuration commitmentDuration) {
            this.commitmentDuration(commitmentDuration == null ? null : commitmentDuration.toString());
            return this;
        }

        public final Instant getCommitmentExpirationTime() {
            return this.commitmentExpirationTime;
        }

        public final void setCommitmentExpirationTime(Instant commitmentExpirationTime) {
            this.commitmentExpirationTime = commitmentExpirationTime;
        }

        @Override
        public final Builder commitmentExpirationTime(Instant commitmentExpirationTime) {
            this.commitmentExpirationTime = commitmentExpirationTime;
            return this;
        }

        @Override
        public GetProvisionedModelThroughputResponse build() {
            return new GetProvisionedModelThroughputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProvisionedModelThroughputResponse> {
        public Builder modelUnits(Integer var1);

        public Builder desiredModelUnits(Integer var1);

        public Builder provisionedModelName(String var1);

        public Builder provisionedModelArn(String var1);

        public Builder modelArn(String var1);

        public Builder desiredModelArn(String var1);

        public Builder foundationModelArn(String var1);

        public Builder status(String var1);

        public Builder status(ProvisionedModelStatus var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureMessage(String var1);

        public Builder commitmentDuration(String var1);

        public Builder commitmentDuration(CommitmentDuration var1);

        public Builder commitmentExpirationTime(Instant var1);
    }
}

