/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFoundationModelResponse extends BedrockResponse implements
        ToCopyableBuilder<GetFoundationModelResponse.Builder, GetFoundationModelResponse> {
    private static final SdkField<FoundationModelDetails> MODEL_DETAILS_FIELD = SdkField
            .<FoundationModelDetails> builder(MarshallingType.SDK_POJO).memberName("modelDetails")
            .getter(getter(GetFoundationModelResponse::modelDetails)).setter(setter(Builder::modelDetails))
            .constructor(FoundationModelDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_DETAILS_FIELD));

    private final FoundationModelDetails modelDetails;

    private GetFoundationModelResponse(BuilderImpl builder) {
        super(builder);
        this.modelDetails = builder.modelDetails;
    }

    /**
     * <p>
     * Information about the foundation model.
     * </p>
     * 
     * @return Information about the foundation model.
     */
    public final FoundationModelDetails modelDetails() {
        return modelDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFoundationModelResponse)) {
            return false;
        }
        GetFoundationModelResponse other = (GetFoundationModelResponse) obj;
        return Objects.equals(modelDetails(), other.modelDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFoundationModelResponse").add("ModelDetails", modelDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelDetails":
            return Optional.ofNullable(clazz.cast(modelDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFoundationModelResponse, T> g) {
        return obj -> g.apply((GetFoundationModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFoundationModelResponse> {
        /**
         * <p>
         * Information about the foundation model.
         * </p>
         * 
         * @param modelDetails
         *        Information about the foundation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDetails(FoundationModelDetails modelDetails);

        /**
         * <p>
         * Information about the foundation model.
         * </p>
         * This is a convenience method that creates an instance of the {@link FoundationModelDetails.Builder} avoiding
         * the need to create one manually via {@link FoundationModelDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FoundationModelDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #modelDetails(FoundationModelDetails)}.
         * 
         * @param modelDetails
         *        a consumer that will call methods on {@link FoundationModelDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDetails(FoundationModelDetails)
         */
        default Builder modelDetails(Consumer<FoundationModelDetails.Builder> modelDetails) {
            return modelDetails(FoundationModelDetails.builder().applyMutation(modelDetails).build());
        }
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private FoundationModelDetails modelDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFoundationModelResponse model) {
            super(model);
            modelDetails(model.modelDetails);
        }

        public final FoundationModelDetails.Builder getModelDetails() {
            return modelDetails != null ? modelDetails.toBuilder() : null;
        }

        public final void setModelDetails(FoundationModelDetails.BuilderImpl modelDetails) {
            this.modelDetails = modelDetails != null ? modelDetails.build() : null;
        }

        @Override
        public final Builder modelDetails(FoundationModelDetails modelDetails) {
            this.modelDetails = modelDetails;
            return this;
        }

        @Override
        public GetFoundationModelResponse build() {
            return new GetFoundationModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
