/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFoundationModelsResponse extends BedrockResponse implements
        ToCopyableBuilder<ListFoundationModelsResponse.Builder, ListFoundationModelsResponse> {
    private static final SdkField<List<FoundationModelSummary>> MODEL_SUMMARIES_FIELD = SdkField
            .<List<FoundationModelSummary>> builder(MarshallingType.LIST)
            .memberName("modelSummaries")
            .getter(getter(ListFoundationModelsResponse::modelSummaries))
            .setter(setter(Builder::modelSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FoundationModelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FoundationModelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_SUMMARIES_FIELD));

    private final List<FoundationModelSummary> modelSummaries;

    private ListFoundationModelsResponse(BuilderImpl builder) {
        super(builder);
        this.modelSummaries = builder.modelSummaries;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModelSummaries() {
        return modelSummaries != null && !(modelSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of bedrock foundation models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelSummaries} method.
     * </p>
     * 
     * @return A list of bedrock foundation models.
     */
    public final List<FoundationModelSummary> modelSummaries() {
        return modelSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasModelSummaries() ? modelSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFoundationModelsResponse)) {
            return false;
        }
        ListFoundationModelsResponse other = (ListFoundationModelsResponse) obj;
        return hasModelSummaries() == other.hasModelSummaries() && Objects.equals(modelSummaries(), other.modelSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFoundationModelsResponse")
                .add("ModelSummaries", hasModelSummaries() ? modelSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelSummaries":
            return Optional.ofNullable(clazz.cast(modelSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFoundationModelsResponse, T> g) {
        return obj -> g.apply((ListFoundationModelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFoundationModelsResponse> {
        /**
         * <p>
         * A list of bedrock foundation models.
         * </p>
         * 
         * @param modelSummaries
         *        A list of bedrock foundation models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSummaries(Collection<FoundationModelSummary> modelSummaries);

        /**
         * <p>
         * A list of bedrock foundation models.
         * </p>
         * 
         * @param modelSummaries
         *        A list of bedrock foundation models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSummaries(FoundationModelSummary... modelSummaries);

        /**
         * <p>
         * A list of bedrock foundation models.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.FoundationModelSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.FoundationModelSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.FoundationModelSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #modelSummaries(List<FoundationModelSummary>)}.
         * 
         * @param modelSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.FoundationModelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelSummaries(java.util.Collection<FoundationModelSummary>)
         */
        Builder modelSummaries(Consumer<FoundationModelSummary.Builder>... modelSummaries);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private List<FoundationModelSummary> modelSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFoundationModelsResponse model) {
            super(model);
            modelSummaries(model.modelSummaries);
        }

        public final List<FoundationModelSummary.Builder> getModelSummaries() {
            List<FoundationModelSummary.Builder> result = FoundationModelSummaryListCopier.copyToBuilder(this.modelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelSummaries(Collection<FoundationModelSummary.BuilderImpl> modelSummaries) {
            this.modelSummaries = FoundationModelSummaryListCopier.copyFromBuilder(modelSummaries);
        }

        @Override
        public final Builder modelSummaries(Collection<FoundationModelSummary> modelSummaries) {
            this.modelSummaries = FoundationModelSummaryListCopier.copy(modelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelSummaries(FoundationModelSummary... modelSummaries) {
            modelSummaries(Arrays.asList(modelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelSummaries(Consumer<FoundationModelSummary.Builder>... modelSummaries) {
            modelSummaries(Stream.of(modelSummaries).map(c -> FoundationModelSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFoundationModelsResponse build() {
            return new ListFoundationModelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
