/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.CloudWatchConfig;
import software.amazon.awssdk.services.bedrock.model.S3Config;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingConfig> {
    private static final SdkField<CloudWatchConfig> CLOUD_WATCH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchConfig").getter(LoggingConfig.getter(LoggingConfig::cloudWatchConfig)).setter(LoggingConfig.setter(Builder::cloudWatchConfig)).constructor(CloudWatchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchConfig").build()}).build();
    private static final SdkField<Boolean> EMBEDDING_DATA_DELIVERY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("embeddingDataDeliveryEnabled").getter(LoggingConfig.getter(LoggingConfig::embeddingDataDeliveryEnabled)).setter(LoggingConfig.setter(Builder::embeddingDataDeliveryEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddingDataDeliveryEnabled").build()}).build();
    private static final SdkField<Boolean> IMAGE_DATA_DELIVERY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("imageDataDeliveryEnabled").getter(LoggingConfig.getter(LoggingConfig::imageDataDeliveryEnabled)).setter(LoggingConfig.setter(Builder::imageDataDeliveryEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDataDeliveryEnabled").build()}).build();
    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Config").getter(LoggingConfig.getter(LoggingConfig::s3Config)).setter(LoggingConfig.setter(Builder::s3Config)).constructor(S3Config::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Config").build()}).build();
    private static final SdkField<Boolean> TEXT_DATA_DELIVERY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("textDataDeliveryEnabled").getter(LoggingConfig.getter(LoggingConfig::textDataDeliveryEnabled)).setter(LoggingConfig.setter(Builder::textDataDeliveryEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textDataDeliveryEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_CONFIG_FIELD, EMBEDDING_DATA_DELIVERY_ENABLED_FIELD, IMAGE_DATA_DELIVERY_ENABLED_FIELD, S3_CONFIG_FIELD, TEXT_DATA_DELIVERY_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final CloudWatchConfig cloudWatchConfig;
    private final Boolean embeddingDataDeliveryEnabled;
    private final Boolean imageDataDeliveryEnabled;
    private final S3Config s3Config;
    private final Boolean textDataDeliveryEnabled;

    private LoggingConfig(BuilderImpl builder) {
        this.cloudWatchConfig = builder.cloudWatchConfig;
        this.embeddingDataDeliveryEnabled = builder.embeddingDataDeliveryEnabled;
        this.imageDataDeliveryEnabled = builder.imageDataDeliveryEnabled;
        this.s3Config = builder.s3Config;
        this.textDataDeliveryEnabled = builder.textDataDeliveryEnabled;
    }

    public final CloudWatchConfig cloudWatchConfig() {
        return this.cloudWatchConfig;
    }

    public final Boolean embeddingDataDeliveryEnabled() {
        return this.embeddingDataDeliveryEnabled;
    }

    public final Boolean imageDataDeliveryEnabled() {
        return this.imageDataDeliveryEnabled;
    }

    public final S3Config s3Config() {
        return this.s3Config;
    }

    public final Boolean textDataDeliveryEnabled() {
        return this.textDataDeliveryEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.embeddingDataDeliveryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDataDeliveryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Config());
        hashCode = 31 * hashCode + Objects.hashCode(this.textDataDeliveryEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfig)) {
            return false;
        }
        LoggingConfig other = (LoggingConfig)obj;
        return Objects.equals(this.cloudWatchConfig(), other.cloudWatchConfig()) && Objects.equals(this.embeddingDataDeliveryEnabled(), other.embeddingDataDeliveryEnabled()) && Objects.equals(this.imageDataDeliveryEnabled(), other.imageDataDeliveryEnabled()) && Objects.equals(this.s3Config(), other.s3Config()) && Objects.equals(this.textDataDeliveryEnabled(), other.textDataDeliveryEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"LoggingConfig").add("CloudWatchConfig", (Object)this.cloudWatchConfig()).add("EmbeddingDataDeliveryEnabled", (Object)this.embeddingDataDeliveryEnabled()).add("ImageDataDeliveryEnabled", (Object)this.imageDataDeliveryEnabled()).add("S3Config", (Object)this.s3Config()).add("TextDataDeliveryEnabled", (Object)this.textDataDeliveryEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchConfig": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchConfig()));
            }
            case "embeddingDataDeliveryEnabled": {
                return Optional.ofNullable(clazz.cast(this.embeddingDataDeliveryEnabled()));
            }
            case "imageDataDeliveryEnabled": {
                return Optional.ofNullable(clazz.cast(this.imageDataDeliveryEnabled()));
            }
            case "s3Config": {
                return Optional.ofNullable(clazz.cast(this.s3Config()));
            }
            case "textDataDeliveryEnabled": {
                return Optional.ofNullable(clazz.cast(this.textDataDeliveryEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfig, T> g) {
        return obj -> g.apply((LoggingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchConfig cloudWatchConfig;
        private Boolean embeddingDataDeliveryEnabled;
        private Boolean imageDataDeliveryEnabled;
        private S3Config s3Config;
        private Boolean textDataDeliveryEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfig model) {
            this.cloudWatchConfig(model.cloudWatchConfig);
            this.embeddingDataDeliveryEnabled(model.embeddingDataDeliveryEnabled);
            this.imageDataDeliveryEnabled(model.imageDataDeliveryEnabled);
            this.s3Config(model.s3Config);
            this.textDataDeliveryEnabled(model.textDataDeliveryEnabled);
        }

        public final CloudWatchConfig.Builder getCloudWatchConfig() {
            return this.cloudWatchConfig != null ? this.cloudWatchConfig.toBuilder() : null;
        }

        public final void setCloudWatchConfig(CloudWatchConfig.BuilderImpl cloudWatchConfig) {
            this.cloudWatchConfig = cloudWatchConfig != null ? cloudWatchConfig.build() : null;
        }

        @Override
        public final Builder cloudWatchConfig(CloudWatchConfig cloudWatchConfig) {
            this.cloudWatchConfig = cloudWatchConfig;
            return this;
        }

        public final Boolean getEmbeddingDataDeliveryEnabled() {
            return this.embeddingDataDeliveryEnabled;
        }

        public final void setEmbeddingDataDeliveryEnabled(Boolean embeddingDataDeliveryEnabled) {
            this.embeddingDataDeliveryEnabled = embeddingDataDeliveryEnabled;
        }

        @Override
        public final Builder embeddingDataDeliveryEnabled(Boolean embeddingDataDeliveryEnabled) {
            this.embeddingDataDeliveryEnabled = embeddingDataDeliveryEnabled;
            return this;
        }

        public final Boolean getImageDataDeliveryEnabled() {
            return this.imageDataDeliveryEnabled;
        }

        public final void setImageDataDeliveryEnabled(Boolean imageDataDeliveryEnabled) {
            this.imageDataDeliveryEnabled = imageDataDeliveryEnabled;
        }

        @Override
        public final Builder imageDataDeliveryEnabled(Boolean imageDataDeliveryEnabled) {
            this.imageDataDeliveryEnabled = imageDataDeliveryEnabled;
            return this;
        }

        public final S3Config.Builder getS3Config() {
            return this.s3Config != null ? this.s3Config.toBuilder() : null;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            this.s3Config = s3Config != null ? s3Config.build() : null;
        }

        @Override
        public final Builder s3Config(S3Config s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        public final Boolean getTextDataDeliveryEnabled() {
            return this.textDataDeliveryEnabled;
        }

        public final void setTextDataDeliveryEnabled(Boolean textDataDeliveryEnabled) {
            this.textDataDeliveryEnabled = textDataDeliveryEnabled;
        }

        @Override
        public final Builder textDataDeliveryEnabled(Boolean textDataDeliveryEnabled) {
            this.textDataDeliveryEnabled = textDataDeliveryEnabled;
            return this;
        }

        public LoggingConfig build() {
            return new LoggingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingConfig> {
        public Builder cloudWatchConfig(CloudWatchConfig var1);

        default public Builder cloudWatchConfig(Consumer<CloudWatchConfig.Builder> cloudWatchConfig) {
            return this.cloudWatchConfig((CloudWatchConfig)((CloudWatchConfig.Builder)CloudWatchConfig.builder().applyMutation(cloudWatchConfig)).build());
        }

        public Builder embeddingDataDeliveryEnabled(Boolean var1);

        public Builder imageDataDeliveryEnabled(Boolean var1);

        public Builder s3Config(S3Config var1);

        default public Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return this.s3Config((S3Config)((S3Config.Builder)S3Config.builder().applyMutation(s3Config)).build());
        }

        public Builder textDataDeliveryEnabled(Boolean var1);
    }
}

