/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClientBuilder;
import software.amazon.awssdk.services.bedrock.BedrockServiceClientConfiguration;
import software.amazon.awssdk.services.bedrock.DefaultBedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.DefaultBedrockBaseClientBuilder;
import software.amazon.awssdk.services.bedrock.endpoints.BedrockEndpointProvider;

@SdkInternalApi
final class DefaultBedrockAsyncClientBuilder
extends DefaultBedrockBaseClientBuilder<BedrockAsyncClientBuilder, BedrockAsyncClient>
implements BedrockAsyncClientBuilder {
    DefaultBedrockAsyncClientBuilder() {
    }

    @Override
    public DefaultBedrockAsyncClientBuilder endpointProvider(BedrockEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BedrockAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultBedrockAsyncClientBuilder.validateClientOptions(clientConfiguration);
        BedrockServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBedrockAsyncClient client = new DefaultBedrockAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BedrockServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BedrockServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

