/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmrecommendedactions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmrecommendedactions.BcmRecommendedActionsClient;
import software.amazon.awssdk.services.bcmrecommendedactions.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest;
import software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsResponse;
import software.amazon.awssdk.services.bcmrecommendedactions.model.RecommendedAction;

public class ListRecommendedActionsIterable
implements SdkIterable<ListRecommendedActionsResponse> {
    private final BcmRecommendedActionsClient client;
    private final ListRecommendedActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecommendedActionsIterable(BcmRecommendedActionsClient client, ListRecommendedActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecommendedActionsResponseFetcher();
    }

    public Iterator<ListRecommendedActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecommendedAction> recommendedActions() {
        Function<ListRecommendedActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendedActions() != null) {
                return response.recommendedActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecommendedActionsResponseFetcher
    implements SyncPageFetcher<ListRecommendedActionsResponse> {
        private ListRecommendedActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendedActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecommendedActionsResponse nextPage(ListRecommendedActionsResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendedActionsIterable.this.client.listRecommendedActions(ListRecommendedActionsIterable.this.firstRequest);
            }
            return ListRecommendedActionsIterable.this.client.listRecommendedActions((ListRecommendedActionsRequest)((Object)ListRecommendedActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

