/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorAsyncClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillEstimateCommitmentSummary;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsResponse;

public class ListBillEstimateCommitmentsPublisher
implements SdkPublisher<ListBillEstimateCommitmentsResponse> {
    private final BcmPricingCalculatorAsyncClient client;
    private final ListBillEstimateCommitmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBillEstimateCommitmentsPublisher(BcmPricingCalculatorAsyncClient client, ListBillEstimateCommitmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBillEstimateCommitmentsPublisher(BcmPricingCalculatorAsyncClient client, ListBillEstimateCommitmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBillEstimateCommitmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBillEstimateCommitmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BillEstimateCommitmentSummary> items() {
        Function<ListBillEstimateCommitmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBillEstimateCommitmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBillEstimateCommitmentsResponseFetcher
    implements AsyncPageFetcher<ListBillEstimateCommitmentsResponse> {
        private ListBillEstimateCommitmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillEstimateCommitmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBillEstimateCommitmentsResponse> nextPage(ListBillEstimateCommitmentsResponse previousPage) {
            if (previousPage == null) {
                return ListBillEstimateCommitmentsPublisher.this.client.listBillEstimateCommitments(ListBillEstimateCommitmentsPublisher.this.firstRequest);
            }
            return ListBillEstimateCommitmentsPublisher.this.client.listBillEstimateCommitments((ListBillEstimateCommitmentsRequest)((Object)ListBillEstimateCommitmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

