/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorAsyncClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillEstimateSummary;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesResponse;

public class ListBillEstimatesPublisher
implements SdkPublisher<ListBillEstimatesResponse> {
    private final BcmPricingCalculatorAsyncClient client;
    private final ListBillEstimatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBillEstimatesPublisher(BcmPricingCalculatorAsyncClient client, ListBillEstimatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBillEstimatesPublisher(BcmPricingCalculatorAsyncClient client, ListBillEstimatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBillEstimatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBillEstimatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BillEstimateSummary> items() {
        Function<ListBillEstimatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBillEstimatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBillEstimatesResponseFetcher
    implements AsyncPageFetcher<ListBillEstimatesResponse> {
        private ListBillEstimatesResponseFetcher() {
        }

        public boolean hasNextPage(ListBillEstimatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBillEstimatesResponse> nextPage(ListBillEstimatesResponse previousPage) {
            if (previousPage == null) {
                return ListBillEstimatesPublisher.this.client.listBillEstimates(ListBillEstimatesPublisher.this.firstRequest);
            }
            return ListBillEstimatesPublisher.this.client.listBillEstimates((ListBillEstimatesRequest)((Object)ListBillEstimatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

