/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorAsyncClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillEstimateLineItemSummary;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsResponse;

public class ListBillEstimateLineItemsPublisher
implements SdkPublisher<ListBillEstimateLineItemsResponse> {
    private final BcmPricingCalculatorAsyncClient client;
    private final ListBillEstimateLineItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBillEstimateLineItemsPublisher(BcmPricingCalculatorAsyncClient client, ListBillEstimateLineItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBillEstimateLineItemsPublisher(BcmPricingCalculatorAsyncClient client, ListBillEstimateLineItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBillEstimateLineItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBillEstimateLineItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BillEstimateLineItemSummary> items() {
        Function<ListBillEstimateLineItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBillEstimateLineItemsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBillEstimateLineItemsResponseFetcher
    implements AsyncPageFetcher<ListBillEstimateLineItemsResponse> {
        private ListBillEstimateLineItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillEstimateLineItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBillEstimateLineItemsResponse> nextPage(ListBillEstimateLineItemsResponse previousPage) {
            if (previousPage == null) {
                return ListBillEstimateLineItemsPublisher.this.client.listBillEstimateLineItems(ListBillEstimateLineItemsPublisher.this.firstRequest);
            }
            return ListBillEstimateLineItemsPublisher.this.client.listBillEstimateLineItems((ListBillEstimateLineItemsRequest)((Object)ListBillEstimateLineItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

