/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationError;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationErrorsCopier;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillScenarioCommitmentModificationItem;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillScenarioCommitmentModificationItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateBillScenarioCommitmentModificationResponse
extends BcmPricingCalculatorResponse
implements ToCopyableBuilder<Builder, BatchUpdateBillScenarioCommitmentModificationResponse> {
    private static final SdkField<List<BillScenarioCommitmentModificationItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(BatchUpdateBillScenarioCommitmentModificationResponse.getter(BatchUpdateBillScenarioCommitmentModificationResponse::items)).setter(BatchUpdateBillScenarioCommitmentModificationResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BillScenarioCommitmentModificationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchUpdateBillScenarioCommitmentModificationError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchUpdateBillScenarioCommitmentModificationResponse.getter(BatchUpdateBillScenarioCommitmentModificationResponse::errors)).setter(BatchUpdateBillScenarioCommitmentModificationResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateBillScenarioCommitmentModificationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("items", ITEMS_FIELD);
            this.put("errors", ERRORS_FIELD);
        }
    });
    private final List<BillScenarioCommitmentModificationItem> items;
    private final List<BatchUpdateBillScenarioCommitmentModificationError> errors;

    private BatchUpdateBillScenarioCommitmentModificationResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.errors = builder.errors;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<BillScenarioCommitmentModificationItem> items() {
        return this.items;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateBillScenarioCommitmentModificationError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateBillScenarioCommitmentModificationResponse)) {
            return false;
        }
        BatchUpdateBillScenarioCommitmentModificationResponse other = (BatchUpdateBillScenarioCommitmentModificationResponse)((Object)obj);
        return this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateBillScenarioCommitmentModificationResponse").add("Items", this.hasItems() ? this.items() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateBillScenarioCommitmentModificationResponse, T> g) {
        return obj -> g.apply((BatchUpdateBillScenarioCommitmentModificationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorResponse.BuilderImpl
    implements Builder {
        private List<BillScenarioCommitmentModificationItem> items = DefaultSdkAutoConstructList.getInstance();
        private List<BatchUpdateBillScenarioCommitmentModificationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateBillScenarioCommitmentModificationResponse model) {
            super(model);
            this.items(model.items);
            this.errors(model.errors);
        }

        public final List<BillScenarioCommitmentModificationItem.Builder> getItems() {
            List<BillScenarioCommitmentModificationItem.Builder> result = BillScenarioCommitmentModificationItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<BillScenarioCommitmentModificationItem.BuilderImpl> items) {
            this.items = BillScenarioCommitmentModificationItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<BillScenarioCommitmentModificationItem> items) {
            this.items = BillScenarioCommitmentModificationItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(BillScenarioCommitmentModificationItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<BillScenarioCommitmentModificationItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (BillScenarioCommitmentModificationItem)((BillScenarioCommitmentModificationItem.Builder)BillScenarioCommitmentModificationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchUpdateBillScenarioCommitmentModificationError.Builder> getErrors() {
            List<BatchUpdateBillScenarioCommitmentModificationError.Builder> result = BatchUpdateBillScenarioCommitmentModificationErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchUpdateBillScenarioCommitmentModificationError.BuilderImpl> errors) {
            this.errors = BatchUpdateBillScenarioCommitmentModificationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchUpdateBillScenarioCommitmentModificationError> errors) {
            this.errors = BatchUpdateBillScenarioCommitmentModificationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchUpdateBillScenarioCommitmentModificationError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchUpdateBillScenarioCommitmentModificationError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchUpdateBillScenarioCommitmentModificationError)((BatchUpdateBillScenarioCommitmentModificationError.Builder)BatchUpdateBillScenarioCommitmentModificationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateBillScenarioCommitmentModificationResponse build() {
            return new BatchUpdateBillScenarioCommitmentModificationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BcmPricingCalculatorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateBillScenarioCommitmentModificationResponse> {
        public Builder items(Collection<BillScenarioCommitmentModificationItem> var1);

        public Builder items(BillScenarioCommitmentModificationItem ... var1);

        public Builder items(Consumer<BillScenarioCommitmentModificationItem.Builder> ... var1);

        public Builder errors(Collection<BatchUpdateBillScenarioCommitmentModificationError> var1);

        public Builder errors(BatchUpdateBillScenarioCommitmentModificationError ... var1);

        public Builder errors(Consumer<BatchUpdateBillScenarioCommitmentModificationError.Builder> ... var1);
    }
}

