/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UsageAmount;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UsageAmountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateBillScenarioUsageModificationEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchUpdateBillScenarioUsageModificationEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(BatchUpdateBillScenarioUsageModificationEntry.getter(BatchUpdateBillScenarioUsageModificationEntry::id)).setter(BatchUpdateBillScenarioUsageModificationEntry.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("group").getter(BatchUpdateBillScenarioUsageModificationEntry.getter(BatchUpdateBillScenarioUsageModificationEntry::group)).setter(BatchUpdateBillScenarioUsageModificationEntry.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<List<UsageAmount>> AMOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("amounts").getter(BatchUpdateBillScenarioUsageModificationEntry.getter(BatchUpdateBillScenarioUsageModificationEntry::amounts)).setter(BatchUpdateBillScenarioUsageModificationEntry.setter(Builder::amounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageAmount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, GROUP_FIELD, AMOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("group", GROUP_FIELD);
            this.put("amounts", AMOUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String group;
    private final List<UsageAmount> amounts;

    private BatchUpdateBillScenarioUsageModificationEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.group = builder.group;
        this.amounts = builder.amounts;
    }

    public final String id() {
        return this.id;
    }

    public final String group() {
        return this.group;
    }

    public final boolean hasAmounts() {
        return this.amounts != null && !(this.amounts instanceof SdkAutoConstructList);
    }

    public final List<UsageAmount> amounts() {
        return this.amounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAmounts() ? this.amounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateBillScenarioUsageModificationEntry)) {
            return false;
        }
        BatchUpdateBillScenarioUsageModificationEntry other = (BatchUpdateBillScenarioUsageModificationEntry)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.group(), other.group()) && this.hasAmounts() == other.hasAmounts() && Objects.equals(this.amounts(), other.amounts());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateBillScenarioUsageModificationEntry").add("Id", (Object)this.id()).add("Group", (Object)this.group()).add("Amounts", this.hasAmounts() ? this.amounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "amounts": {
                return Optional.ofNullable(clazz.cast(this.amounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateBillScenarioUsageModificationEntry, T> g) {
        return obj -> g.apply((BatchUpdateBillScenarioUsageModificationEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String group;
        private List<UsageAmount> amounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateBillScenarioUsageModificationEntry model) {
            this.id(model.id);
            this.group(model.group);
            this.amounts(model.amounts);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final List<UsageAmount.Builder> getAmounts() {
            List<UsageAmount.Builder> result = UsageAmountsCopier.copyToBuilder(this.amounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmounts(Collection<UsageAmount.BuilderImpl> amounts) {
            this.amounts = UsageAmountsCopier.copyFromBuilder(amounts);
        }

        @Override
        public final Builder amounts(Collection<UsageAmount> amounts) {
            this.amounts = UsageAmountsCopier.copy(amounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(UsageAmount ... amounts) {
            this.amounts(Arrays.asList(amounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(Consumer<UsageAmount.Builder> ... amounts) {
            this.amounts(Stream.of(amounts).map(c -> (UsageAmount)((UsageAmount.Builder)UsageAmount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BatchUpdateBillScenarioUsageModificationEntry build() {
            return new BatchUpdateBillScenarioUsageModificationEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchUpdateBillScenarioUsageModificationEntry> {
        public Builder id(String var1);

        public Builder group(String var1);

        public Builder amounts(Collection<UsageAmount> var1);

        public Builder amounts(UsageAmount ... var1);

        public Builder amounts(Consumer<UsageAmount.Builder> ... var1);
    }
}

