/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationEntriesCopier;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationEntry;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateBillScenarioUsageModificationRequest
extends BcmPricingCalculatorRequest
implements ToCopyableBuilder<Builder, BatchUpdateBillScenarioUsageModificationRequest> {
    private static final SdkField<String> BILL_SCENARIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billScenarioId").getter(BatchUpdateBillScenarioUsageModificationRequest.getter(BatchUpdateBillScenarioUsageModificationRequest::billScenarioId)).setter(BatchUpdateBillScenarioUsageModificationRequest.setter(Builder::billScenarioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billScenarioId").build()}).build();
    private static final SdkField<List<BatchUpdateBillScenarioUsageModificationEntry>> USAGE_MODIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("usageModifications").getter(BatchUpdateBillScenarioUsageModificationRequest.getter(BatchUpdateBillScenarioUsageModificationRequest::usageModifications)).setter(BatchUpdateBillScenarioUsageModificationRequest.setter(Builder::usageModifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageModifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateBillScenarioUsageModificationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILL_SCENARIO_ID_FIELD, USAGE_MODIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("billScenarioId", BILL_SCENARIO_ID_FIELD);
            this.put("usageModifications", USAGE_MODIFICATIONS_FIELD);
        }
    });
    private final String billScenarioId;
    private final List<BatchUpdateBillScenarioUsageModificationEntry> usageModifications;

    private BatchUpdateBillScenarioUsageModificationRequest(BuilderImpl builder) {
        super(builder);
        this.billScenarioId = builder.billScenarioId;
        this.usageModifications = builder.usageModifications;
    }

    public final String billScenarioId() {
        return this.billScenarioId;
    }

    public final boolean hasUsageModifications() {
        return this.usageModifications != null && !(this.usageModifications instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateBillScenarioUsageModificationEntry> usageModifications() {
        return this.usageModifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.billScenarioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsageModifications() ? this.usageModifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateBillScenarioUsageModificationRequest)) {
            return false;
        }
        BatchUpdateBillScenarioUsageModificationRequest other = (BatchUpdateBillScenarioUsageModificationRequest)((Object)obj);
        return Objects.equals(this.billScenarioId(), other.billScenarioId()) && this.hasUsageModifications() == other.hasUsageModifications() && Objects.equals(this.usageModifications(), other.usageModifications());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateBillScenarioUsageModificationRequest").add("BillScenarioId", (Object)this.billScenarioId()).add("UsageModifications", this.hasUsageModifications() ? this.usageModifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "billScenarioId": {
                return Optional.ofNullable(clazz.cast(this.billScenarioId()));
            }
            case "usageModifications": {
                return Optional.ofNullable(clazz.cast(this.usageModifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateBillScenarioUsageModificationRequest, T> g) {
        return obj -> g.apply((BatchUpdateBillScenarioUsageModificationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorRequest.BuilderImpl
    implements Builder {
        private String billScenarioId;
        private List<BatchUpdateBillScenarioUsageModificationEntry> usageModifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateBillScenarioUsageModificationRequest model) {
            super(model);
            this.billScenarioId(model.billScenarioId);
            this.usageModifications(model.usageModifications);
        }

        public final String getBillScenarioId() {
            return this.billScenarioId;
        }

        public final void setBillScenarioId(String billScenarioId) {
            this.billScenarioId = billScenarioId;
        }

        @Override
        public final Builder billScenarioId(String billScenarioId) {
            this.billScenarioId = billScenarioId;
            return this;
        }

        public final List<BatchUpdateBillScenarioUsageModificationEntry.Builder> getUsageModifications() {
            List<BatchUpdateBillScenarioUsageModificationEntry.Builder> result = BatchUpdateBillScenarioUsageModificationEntriesCopier.copyToBuilder(this.usageModifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsageModifications(Collection<BatchUpdateBillScenarioUsageModificationEntry.BuilderImpl> usageModifications) {
            this.usageModifications = BatchUpdateBillScenarioUsageModificationEntriesCopier.copyFromBuilder(usageModifications);
        }

        @Override
        public final Builder usageModifications(Collection<BatchUpdateBillScenarioUsageModificationEntry> usageModifications) {
            this.usageModifications = BatchUpdateBillScenarioUsageModificationEntriesCopier.copy(usageModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageModifications(BatchUpdateBillScenarioUsageModificationEntry ... usageModifications) {
            this.usageModifications(Arrays.asList(usageModifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageModifications(Consumer<BatchUpdateBillScenarioUsageModificationEntry.Builder> ... usageModifications) {
            this.usageModifications(Stream.of(usageModifications).map(c -> (BatchUpdateBillScenarioUsageModificationEntry)((BatchUpdateBillScenarioUsageModificationEntry.Builder)BatchUpdateBillScenarioUsageModificationEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateBillScenarioUsageModificationRequest build() {
            return new BatchUpdateBillScenarioUsageModificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BcmPricingCalculatorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateBillScenarioUsageModificationRequest> {
        public Builder billScenarioId(String var1);

        public Builder usageModifications(Collection<BatchUpdateBillScenarioUsageModificationEntry> var1);

        public Builder usageModifications(BatchUpdateBillScenarioUsageModificationEntry ... var1);

        public Builder usageModifications(Consumer<BatchUpdateBillScenarioUsageModificationEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

