/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageError;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageErrorsCopier;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageItem;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageItemsCopier;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateWorkloadEstimateUsageResponse
extends BcmPricingCalculatorResponse
implements ToCopyableBuilder<Builder, BatchCreateWorkloadEstimateUsageResponse> {
    private static final SdkField<List<BatchCreateWorkloadEstimateUsageItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(BatchCreateWorkloadEstimateUsageResponse.getter(BatchCreateWorkloadEstimateUsageResponse::items)).setter(BatchCreateWorkloadEstimateUsageResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchCreateWorkloadEstimateUsageItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchCreateWorkloadEstimateUsageError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchCreateWorkloadEstimateUsageResponse.getter(BatchCreateWorkloadEstimateUsageResponse::errors)).setter(BatchCreateWorkloadEstimateUsageResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchCreateWorkloadEstimateUsageError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("items", ITEMS_FIELD);
            this.put("errors", ERRORS_FIELD);
        }
    });
    private final List<BatchCreateWorkloadEstimateUsageItem> items;
    private final List<BatchCreateWorkloadEstimateUsageError> errors;

    private BatchCreateWorkloadEstimateUsageResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.errors = builder.errors;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<BatchCreateWorkloadEstimateUsageItem> items() {
        return this.items;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchCreateWorkloadEstimateUsageError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateWorkloadEstimateUsageResponse)) {
            return false;
        }
        BatchCreateWorkloadEstimateUsageResponse other = (BatchCreateWorkloadEstimateUsageResponse)((Object)obj);
        return this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateWorkloadEstimateUsageResponse").add("Items", this.hasItems() ? this.items() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateWorkloadEstimateUsageResponse, T> g) {
        return obj -> g.apply((BatchCreateWorkloadEstimateUsageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorResponse.BuilderImpl
    implements Builder {
        private List<BatchCreateWorkloadEstimateUsageItem> items = DefaultSdkAutoConstructList.getInstance();
        private List<BatchCreateWorkloadEstimateUsageError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateWorkloadEstimateUsageResponse model) {
            super(model);
            this.items(model.items);
            this.errors(model.errors);
        }

        public final List<BatchCreateWorkloadEstimateUsageItem.Builder> getItems() {
            List<BatchCreateWorkloadEstimateUsageItem.Builder> result = BatchCreateWorkloadEstimateUsageItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<BatchCreateWorkloadEstimateUsageItem.BuilderImpl> items) {
            this.items = BatchCreateWorkloadEstimateUsageItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<BatchCreateWorkloadEstimateUsageItem> items) {
            this.items = BatchCreateWorkloadEstimateUsageItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(BatchCreateWorkloadEstimateUsageItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<BatchCreateWorkloadEstimateUsageItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (BatchCreateWorkloadEstimateUsageItem)((BatchCreateWorkloadEstimateUsageItem.Builder)BatchCreateWorkloadEstimateUsageItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchCreateWorkloadEstimateUsageError.Builder> getErrors() {
            List<BatchCreateWorkloadEstimateUsageError.Builder> result = BatchCreateWorkloadEstimateUsageErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchCreateWorkloadEstimateUsageError.BuilderImpl> errors) {
            this.errors = BatchCreateWorkloadEstimateUsageErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchCreateWorkloadEstimateUsageError> errors) {
            this.errors = BatchCreateWorkloadEstimateUsageErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchCreateWorkloadEstimateUsageError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchCreateWorkloadEstimateUsageError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchCreateWorkloadEstimateUsageError)((BatchCreateWorkloadEstimateUsageError.Builder)BatchCreateWorkloadEstimateUsageError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchCreateWorkloadEstimateUsageResponse build() {
            return new BatchCreateWorkloadEstimateUsageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BcmPricingCalculatorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateWorkloadEstimateUsageResponse> {
        public Builder items(Collection<BatchCreateWorkloadEstimateUsageItem> var1);

        public Builder items(BatchCreateWorkloadEstimateUsageItem ... var1);

        public Builder items(Consumer<BatchCreateWorkloadEstimateUsageItem.Builder> ... var1);

        public Builder errors(Collection<BatchCreateWorkloadEstimateUsageError> var1);

        public Builder errors(BatchCreateWorkloadEstimateUsageError ... var1);

        public Builder errors(Consumer<BatchCreateWorkloadEstimateUsageError.Builder> ... var1);
    }
}

