/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The cadence for Amazon Web Services to update the data export in your S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshCadence implements SdkPojo, Serializable, ToCopyableBuilder<RefreshCadence.Builder, RefreshCadence> {
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Frequency").getter(getter(RefreshCadence::frequencyAsString)).setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String frequency;

    private RefreshCadence(BuilderImpl builder) {
        this.frequency = builder.frequency;
    }

    /**
     * <p>
     * The frequency that data exports are updated. The export refreshes each time the source data updates, up to three
     * times daily.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link FrequencyOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return The frequency that data exports are updated. The export refreshes each time the source data updates, up
     *         to three times daily.
     * @see FrequencyOption
     */
    public final FrequencyOption frequency() {
        return FrequencyOption.fromValue(frequency);
    }

    /**
     * <p>
     * The frequency that data exports are updated. The export refreshes each time the source data updates, up to three
     * times daily.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link FrequencyOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return The frequency that data exports are updated. The export refreshes each time the source data updates, up
     *         to three times daily.
     * @see FrequencyOption
     */
    public final String frequencyAsString() {
        return frequency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frequencyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshCadence)) {
            return false;
        }
        RefreshCadence other = (RefreshCadence) obj;
        return Objects.equals(frequencyAsString(), other.frequencyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshCadence").add("Frequency", frequencyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Frequency":
            return Optional.ofNullable(clazz.cast(frequencyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Frequency", FREQUENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefreshCadence, T> g) {
        return obj -> g.apply((RefreshCadence) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RefreshCadence> {
        /**
         * <p>
         * The frequency that data exports are updated. The export refreshes each time the source data updates, up to
         * three times daily.
         * </p>
         * 
         * @param frequency
         *        The frequency that data exports are updated. The export refreshes each time the source data updates,
         *        up to three times daily.
         * @see FrequencyOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FrequencyOption
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * The frequency that data exports are updated. The export refreshes each time the source data updates, up to
         * three times daily.
         * </p>
         * 
         * @param frequency
         *        The frequency that data exports are updated. The export refreshes each time the source data updates,
         *        up to three times daily.
         * @see FrequencyOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FrequencyOption
         */
        Builder frequency(FrequencyOption frequency);
    }

    static final class BuilderImpl implements Builder {
        private String frequency;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshCadence model) {
            frequency(model.frequency);
        }

        public final String getFrequency() {
            return frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(FrequencyOption frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        @Override
        public RefreshCadence build() {
            return new RefreshCadence(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
