/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SQL query of column selections and row filters from the data table you want.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQuery implements SdkPojo, Serializable, ToCopyableBuilder<DataQuery.Builder, DataQuery> {
    private static final SdkField<String> QUERY_STATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryStatement").getter(getter(DataQuery::queryStatement)).setter(setter(Builder::queryStatement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatement").build()).build();

    private static final SdkField<Map<String, Map<String, String>>> TABLE_CONFIGURATIONS_FIELD = SdkField
            .<Map<String, Map<String, String>>> builder(MarshallingType.MAP)
            .memberName("TableConfigurations")
            .getter(getter(DataQuery::tableConfigurations))
            .setter(setter(Builder::tableConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableConfigurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STATEMENT_FIELD,
            TABLE_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String queryStatement;

    private final Map<String, Map<String, String>> tableConfigurations;

    private DataQuery(BuilderImpl builder) {
        this.queryStatement = builder.queryStatement;
        this.tableConfigurations = builder.tableConfigurations;
    }

    /**
     * <p>
     * The query statement.
     * </p>
     * 
     * @return The query statement.
     */
    public final String queryStatement() {
        return queryStatement;
    }

    /**
     * For responses, this returns true if the service returned a value for the TableConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTableConfigurations() {
        return tableConfigurations != null && !(tableConfigurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The table configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTableConfigurations} method.
     * </p>
     * 
     * @return The table configuration.
     */
    public final Map<String, Map<String, String>> tableConfigurations() {
        return tableConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryStatement());
        hashCode = 31 * hashCode + Objects.hashCode(hasTableConfigurations() ? tableConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQuery)) {
            return false;
        }
        DataQuery other = (DataQuery) obj;
        return Objects.equals(queryStatement(), other.queryStatement())
                && hasTableConfigurations() == other.hasTableConfigurations()
                && Objects.equals(tableConfigurations(), other.tableConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQuery").add("QueryStatement", queryStatement())
                .add("TableConfigurations", hasTableConfigurations() ? tableConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryStatement":
            return Optional.ofNullable(clazz.cast(queryStatement()));
        case "TableConfigurations":
            return Optional.ofNullable(clazz.cast(tableConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryStatement", QUERY_STATEMENT_FIELD);
        map.put("TableConfigurations", TABLE_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQuery, T> g) {
        return obj -> g.apply((DataQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQuery> {
        /**
         * <p>
         * The query statement.
         * </p>
         * 
         * @param queryStatement
         *        The query statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStatement(String queryStatement);

        /**
         * <p>
         * The table configuration.
         * </p>
         * 
         * @param tableConfigurations
         *        The table configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableConfigurations(Map<String, ? extends Map<String, String>> tableConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String queryStatement;

        private Map<String, Map<String, String>> tableConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataQuery model) {
            queryStatement(model.queryStatement);
            tableConfigurations(model.tableConfigurations);
        }

        public final String getQueryStatement() {
            return queryStatement;
        }

        public final void setQueryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
        }

        @Override
        public final Builder queryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getTableConfigurations() {
            if (tableConfigurations instanceof SdkAutoConstructMap) {
                return null;
            }
            return tableConfigurations;
        }

        public final void setTableConfigurations(Map<String, ? extends Map<String, String>> tableConfigurations) {
            this.tableConfigurations = TableConfigurationsCopier.copy(tableConfigurations);
        }

        @Override
        public final Builder tableConfigurations(Map<String, ? extends Map<String, String>> tableConfigurations) {
            this.tableConfigurations = TableConfigurationsCopier.copy(tableConfigurations);
            return this;
        }

        @Override
        public DataQuery build() {
            return new DataQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
