/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmdataexports.model.DataQuery;
import software.amazon.awssdk.services.bcmdataexports.model.DestinationConfigurations;
import software.amazon.awssdk.services.bcmdataexports.model.RefreshCadence;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Export
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Export> {
    private static final SdkField<DataQuery> DATA_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataQuery").getter(Export.getter(Export::dataQuery)).setter(Export.setter(Builder::dataQuery)).constructor(DataQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQuery").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Export.getter(Export::description)).setter(Export.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<DestinationConfigurations> DESTINATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationConfigurations").getter(Export.getter(Export::destinationConfigurations)).setter(Export.setter(Builder::destinationConfigurations)).constructor(DestinationConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfigurations").build()}).build();
    private static final SdkField<String> EXPORT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportArn").getter(Export.getter(Export::exportArn)).setter(Export.setter(Builder::exportArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Export.getter(Export::name)).setter(Export.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<RefreshCadence> REFRESH_CADENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RefreshCadence").getter(Export.getter(Export::refreshCadence)).setter(Export.setter(Builder::refreshCadence)).constructor(RefreshCadence::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshCadence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_QUERY_FIELD, DESCRIPTION_FIELD, DESTINATION_CONFIGURATIONS_FIELD, EXPORT_ARN_FIELD, NAME_FIELD, REFRESH_CADENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Export.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DataQuery dataQuery;
    private final String description;
    private final DestinationConfigurations destinationConfigurations;
    private final String exportArn;
    private final String name;
    private final RefreshCadence refreshCadence;

    private Export(BuilderImpl builder) {
        this.dataQuery = builder.dataQuery;
        this.description = builder.description;
        this.destinationConfigurations = builder.destinationConfigurations;
        this.exportArn = builder.exportArn;
        this.name = builder.name;
        this.refreshCadence = builder.refreshCadence;
    }

    public final DataQuery dataQuery() {
        return this.dataQuery;
    }

    public final String description() {
        return this.description;
    }

    public final DestinationConfigurations destinationConfigurations() {
        return this.destinationConfigurations;
    }

    public final String exportArn() {
        return this.exportArn;
    }

    public final String name() {
        return this.name;
    }

    public final RefreshCadence refreshCadence() {
        return this.refreshCadence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshCadence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Export)) {
            return false;
        }
        Export other = (Export)obj;
        return Objects.equals(this.dataQuery(), other.dataQuery()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.destinationConfigurations(), other.destinationConfigurations()) && Objects.equals(this.exportArn(), other.exportArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.refreshCadence(), other.refreshCadence());
    }

    public final String toString() {
        return ToString.builder((String)"Export").add("DataQuery", (Object)this.dataQuery()).add("Description", (Object)this.description()).add("DestinationConfigurations", (Object)this.destinationConfigurations()).add("ExportArn", (Object)this.exportArn()).add("Name", (Object)this.name()).add("RefreshCadence", (Object)this.refreshCadence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataQuery": {
                return Optional.ofNullable(clazz.cast(this.dataQuery()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DestinationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.destinationConfigurations()));
            }
            case "ExportArn": {
                return Optional.ofNullable(clazz.cast(this.exportArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RefreshCadence": {
                return Optional.ofNullable(clazz.cast(this.refreshCadence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataQuery", DATA_QUERY_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DestinationConfigurations", DESTINATION_CONFIGURATIONS_FIELD);
        map.put("ExportArn", EXPORT_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RefreshCadence", REFRESH_CADENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Export, T> g) {
        return obj -> g.apply((Export)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataQuery dataQuery;
        private String description;
        private DestinationConfigurations destinationConfigurations;
        private String exportArn;
        private String name;
        private RefreshCadence refreshCadence;

        private BuilderImpl() {
        }

        private BuilderImpl(Export model) {
            this.dataQuery(model.dataQuery);
            this.description(model.description);
            this.destinationConfigurations(model.destinationConfigurations);
            this.exportArn(model.exportArn);
            this.name(model.name);
            this.refreshCadence(model.refreshCadence);
        }

        public final DataQuery.Builder getDataQuery() {
            return this.dataQuery != null ? this.dataQuery.toBuilder() : null;
        }

        public final void setDataQuery(DataQuery.BuilderImpl dataQuery) {
            this.dataQuery = dataQuery != null ? dataQuery.build() : null;
        }

        @Override
        public final Builder dataQuery(DataQuery dataQuery) {
            this.dataQuery = dataQuery;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DestinationConfigurations.Builder getDestinationConfigurations() {
            return this.destinationConfigurations != null ? this.destinationConfigurations.toBuilder() : null;
        }

        public final void setDestinationConfigurations(DestinationConfigurations.BuilderImpl destinationConfigurations) {
            this.destinationConfigurations = destinationConfigurations != null ? destinationConfigurations.build() : null;
        }

        @Override
        public final Builder destinationConfigurations(DestinationConfigurations destinationConfigurations) {
            this.destinationConfigurations = destinationConfigurations;
            return this;
        }

        public final String getExportArn() {
            return this.exportArn;
        }

        public final void setExportArn(String exportArn) {
            this.exportArn = exportArn;
        }

        @Override
        public final Builder exportArn(String exportArn) {
            this.exportArn = exportArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RefreshCadence.Builder getRefreshCadence() {
            return this.refreshCadence != null ? this.refreshCadence.toBuilder() : null;
        }

        public final void setRefreshCadence(RefreshCadence.BuilderImpl refreshCadence) {
            this.refreshCadence = refreshCadence != null ? refreshCadence.build() : null;
        }

        @Override
        public final Builder refreshCadence(RefreshCadence refreshCadence) {
            this.refreshCadence = refreshCadence;
            return this;
        }

        public Export build() {
            return new Export(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Export> {
        public Builder dataQuery(DataQuery var1);

        default public Builder dataQuery(Consumer<DataQuery.Builder> dataQuery) {
            return this.dataQuery((DataQuery)((DataQuery.Builder)DataQuery.builder().applyMutation(dataQuery)).build());
        }

        public Builder description(String var1);

        public Builder destinationConfigurations(DestinationConfigurations var1);

        default public Builder destinationConfigurations(Consumer<DestinationConfigurations.Builder> destinationConfigurations) {
            return this.destinationConfigurations((DestinationConfigurations)((DestinationConfigurations.Builder)DestinationConfigurations.builder().applyMutation(destinationConfigurations)).build());
        }

        public Builder exportArn(String var1);

        public Builder name(String var1);

        public Builder refreshCadence(RefreshCadence var1);

        default public Builder refreshCadence(Consumer<RefreshCadence.Builder> refreshCadence) {
            return this.refreshCadence((RefreshCadence)((RefreshCadence.Builder)RefreshCadence.builder().applyMutation(refreshCadence)).build());
        }
    }
}

