/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3OutputType {
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3OutputType> VALUE_MAP;
    private final String value;

    private S3OutputType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3OutputType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3OutputType> knownValues() {
        EnumSet<S3OutputType> knownValues = EnumSet.allOf(S3OutputType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3OutputType.class, S3OutputType::toString);
    }
}

